package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 使用单位白名单
 *
 * @author lv
 * @create 2024/6/22 14:49
 * @since 1.0.0
 */
public class UnitWhiteListMessage {

    @Data
    public static class Request {

        /**
         * 使用单位纳税人税号 否
         */
        private String taxNo;

        /**
         * 使用单位纳税人名称 否
         */
        private String taxpayerName;

        /**
         * 页码（必须）
         */
        private Integer pageNumber = 1;

        /**
         * 每页数量（必须）
         */
        private Integer pageSize = 100;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        private String traceId;
        public Object result ;
    }
}
