package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

/**
 * @Auther lv
 * @Date 2023/2/20
 */
public enum InvoiceStatusEnum {

    /**
     * 发票状态（非必须）
     * 0-正常
     * 2-作废
     * 3-已红冲
     * 7-部分红冲
     * 8-全额冲红
     */
    STATUS_0("0", "正常"),
    STATUS_2("2", "作废"),
    STATUS_3("3", "已红冲"),
    STATUS_7("7", "部分红冲"),
    STATUS_8("7", "全额冲红"),

    /**
     * 异常凭证状态（非必须）-风险状态
     * 01-正常
     * 02-异常凭证
     * 03-疑似异常凭证
     */
    RISK_STATUS_01("01", "正常"),
    RISK_STATUS_02("02", "异常凭证"),
    RISK_STATUS_03("03", "疑似异常凭证"),

    /**
     * 红字锁定标识（非必须）
     * Y-锁定；N-未锁定
     */
    RED_LETTER_BLOCK_FLAG_Y("Y", "锁定"),
    RED_LETTER_BLOCK_FLAG_N("Y", "未锁定"),

    /**
     * 发票用途（非必须）
     * 0-未使用
     * 1-已申请抵扣
     * 2-已申请退税
     * 3-已申请代办退税
     * 4-已勾选不抵扣（历史数据）
     * 5-已申请代办退税（历史数据）
     * 6-已申请不抵扣
     * 7-内销转出口
     * 8-出口转内销
     * 9-准予退税
     * 10-不予退税
     * 11-冬奥退税
     * 12-农产品加计扣除
     */
    VAT_USAGE_LABEL_0("0", "未使用"),
    VAT_USAGE_LABEL_1("1", "已申请抵扣"),
    VAT_USAGE_LABEL_2("2", "已申请退税"),
    VAT_USAGE_LABEL_3("3", "已申请代办退税"),
    VAT_USAGE_LABEL_4("4", "已勾选不抵扣（历史数据）"),
    VAT_USAGE_LABEL_5("5", "已申请代办退税（历史数据）"),
    VAT_USAGE_LABEL_6("6", "已申请不抵扣"),
    VAT_USAGE_LABEL_7("7", "内销转出口"),
    VAT_USAGE_LABEL_8("8", "出口转内销"),
    VAT_USAGE_LABEL_9("9", "准予退税"),
    VAT_USAGE_LABEL_10("10", "不予退税"),
    VAT_USAGE_LABEL_11("11", "冬奥退税"),
    VAT_USAGE_LABEL_12("12", "农产品加计扣除"),

    /**  /**
     * 增值税优惠用途（农产品加计扣除，非必须）
     * 0：未使用
     * 1：全部项目加计
     * 2：全部项目不加计
     * 3：部分项目加计
     */
    VAT_PRE_USAGE_0("0", "未使用"),
    VAT_PRE_USAGE_1("1", "全部项目加计"),
    VAT_PRE_USAGE_2("2", "全部项目不加计"),
    VAT_PRE_USAGE_3("3", "部分项目加计"),

    /**
     * 消费税用途
     * 00：未勾选库存
     * 01：已勾选库存
     */
    EXCISE_USAGE_00("00", "未勾选库存"),
    EXCISE_USAGE_01("01", "已勾选库存"),

    /**
     * 入账状态（非必须）
     * 01-未入账
     * 02-已入账
     * 03-已入账撤销
     */
    ENTRY_STATUS_01("01", "未入账"),
    ENTRY_STATUS_02("02", "已入账"),
    ENTRY_STATUS_03("03", "已入账撤销"),

    /**
     * 成品油异常标识（非必须）
     * 9-正常
     * 1-成品油单价异常
     * 2-成品油超库存异常
     */
    OIL_ABNORMAL_FLAG_9("9", "正常"),
    OIL_ABNORMAL_FLAG_1("1", "成品油单价异常"),
    OIL_ABNORMAL_FLAG_2("2", "成品油超库存异常"),

    /**
     * 出口退税类代码（非必须）
     * 01-增值税专用发票可用于代办退税标签（仅用于代办退税）
     */
    EXPORT_POLICY_CODE_01("01", "增值税专用发票可用于代办退税标签（仅用于代办退税）");


    /**
     * 成员变量
     */
    private final String status;
    private final String statusDesc;

    /**
     * 构造方法
     */
    InvoiceStatusEnum(String status, String statusDesc) {
        this.status = status;
        this.statusDesc = statusDesc;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    //因所有的发票状态均维护在此，status有重复项，故不支持根据status 获取statusDesc
}
