package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Auther lv
 * @Date 2023/2/20
 */
public enum SellerTaxpayerStatusEnum {
    /**
     * 开票方纳税人状态
     */
    SELLER_TAXPAYER_STATUS_01("01", "受理"),
    SELLER_TAXPAYER_STATUS_02("02", "筹建期"),
    SELLER_TAXPAYER_STATUS_03("03", "正常"),
    SELLER_TAXPAYER_STATUS_04("04", "停业"),
    SELLER_TAXPAYER_STATUS_05("05", "非正常"),
    SELLER_TAXPAYER_STATUS_06("06", "清算"),
    SELLER_TAXPAYER_STATUS_07("07", "注销"),
    SELLER_TAXPAYER_STATUS_08("08", "非正常户注销"),
    SELLER_TAXPAYER_STATUS_09("09", "报验"),
    SELLER_TAXPAYER_STATUS_10("10", "核销报验"),
    SELLER_TAXPAYER_STATUS_11("11", "中断缴费"),
    SELLER_TAXPAYER_STATUS_12("12", "恢复缴费"),
    SELLER_TAXPAYER_STATUS_13("13", "简易注销无异议"),
    SELLER_TAXPAYER_STATUS_99("99", "其他");

    /**
     * 成员变量
     */
    private String status;
    private String statusDesc;

    /**
     * 构造方法
     */
    SellerTaxpayerStatusEnum(String status, String statusDesc) {
        this.status = status;
        this.statusDesc = statusDesc;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public static SellerTaxpayerStatusEnum fromStatus(String status) {

        return Arrays.stream(SellerTaxpayerStatusEnum.values())
                .filter(value -> Objects.equals(value.status, status))
                .findAny().orElse(null);

    }
}
