package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Auther lv
 * @Date 2023/2/20
 */
public enum TaxpayerRiskTypeEnum {

    /**
     * 风险纳税人类型（非必须）
     */
    TAXPAYER_RISK_TYPE("", "非空风险纳税人"),
    TAXPAYER_RISK_TYPE_01("01", "Ⅰ类（高风险）纳税人"),
    TAXPAYER_RISK_TYPE_02("02", "Ⅱ类（中风险）纳税人"),
    TAXPAYER_RISK_TYPE_03("03", "Ⅲ类（低风险）纳税人"),
    TAXPAYER_RISK_TYPE_04("04", "Ⅳ类（无风险）纳税人");

    /**
     * 成员变量
     */
    private String status;
    private String statusDesc;

    /**
     * 构造方法
     */
    TaxpayerRiskTypeEnum(String status, String statusDesc) {
        this.status = status;
        this.statusDesc = statusDesc;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public static TaxpayerRiskTypeEnum fromStatus(String status) {

        return Arrays.stream(TaxpayerRiskTypeEnum.values())
                .filter(value -> Objects.equals(value.status, status))
                .findAny().orElse(null);

    }
}
