/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.contract.model.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ValidateResult {
    private boolean isSuccess = false;
    private List<ErrorInfo> errorInfoList = new ArrayList<ErrorInfo>();

    public static ValidateResult fail(String errorMessage) {
        return ValidateResult.fail(null, errorMessage);
    }

    public static ValidateResult fail(String errorFieldName, String errorMessage) {
        ErrorInfo errorInfo = new ErrorInfo();
        errorInfo.setErrorFieldName(errorFieldName);
        errorInfo.setErrorMessage(errorMessage);
        return ValidateResult.fail(Arrays.asList(errorInfo));
    }

    public static ValidateResult fail(List<ErrorInfo> errorInfoList) {
        ValidateResult validateResult = new ValidateResult();
        validateResult.isSuccess = false;
        validateResult.setErrorInfoList(errorInfoList);
        return validateResult;
    }

    public static ValidateResult success() {
        ValidateResult validateResult = new ValidateResult();
        validateResult.isSuccess = true;
        return validateResult;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public List<ErrorInfo> getErrorInfoList() {
        return this.errorInfoList;
    }

    public void setSuccess(boolean isSuccess) {
        this.isSuccess = isSuccess;
    }

    public void setErrorInfoList(List<ErrorInfo> errorInfoList) {
        this.errorInfoList = errorInfoList;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ValidateResult)) {
            return false;
        }
        ValidateResult other = (ValidateResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSuccess() != other.isSuccess()) {
            return false;
        }
        List<ErrorInfo> this$errorInfoList = this.getErrorInfoList();
        List<ErrorInfo> other$errorInfoList = other.getErrorInfoList();
        return !(this$errorInfoList == null ? other$errorInfoList != null : !((Object)this$errorInfoList).equals(other$errorInfoList));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ValidateResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSuccess() ? 79 : 97);
        List<ErrorInfo> $errorInfoList = this.getErrorInfoList();
        result = result * 59 + ($errorInfoList == null ? 43 : ((Object)$errorInfoList).hashCode());
        return result;
    }

    public String toString() {
        return "ValidateResult(isSuccess=" + this.isSuccess() + ", errorInfoList=" + this.getErrorInfoList() + ")";
    }

    public static class ErrorInfo {
        private String rowNum;
        private String errorFieldName;
        private String errorMessage;

        public ErrorInfo() {
        }

        public ErrorInfo(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public String getRowNum() {
            return this.rowNum;
        }

        public String getErrorFieldName() {
            return this.errorFieldName;
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public void setRowNum(String rowNum) {
            this.rowNum = rowNum;
        }

        public void setErrorFieldName(String errorFieldName) {
            this.errorFieldName = errorFieldName;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ErrorInfo)) {
                return false;
            }
            ErrorInfo other = (ErrorInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$rowNum = this.getRowNum();
            String other$rowNum = other.getRowNum();
            if (this$rowNum == null ? other$rowNum != null : !this$rowNum.equals(other$rowNum)) {
                return false;
            }
            String this$errorFieldName = this.getErrorFieldName();
            String other$errorFieldName = other.getErrorFieldName();
            if (this$errorFieldName == null ? other$errorFieldName != null : !this$errorFieldName.equals(other$errorFieldName)) {
                return false;
            }
            String this$errorMessage = this.getErrorMessage();
            String other$errorMessage = other.getErrorMessage();
            return !(this$errorMessage == null ? other$errorMessage != null : !this$errorMessage.equals(other$errorMessage));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ErrorInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $rowNum = this.getRowNum();
            result = result * 59 + ($rowNum == null ? 43 : $rowNum.hashCode());
            String $errorFieldName = this.getErrorFieldName();
            result = result * 59 + ($errorFieldName == null ? 43 : $errorFieldName.hashCode());
            String $errorMessage = this.getErrorMessage();
            result = result * 59 + ($errorMessage == null ? 43 : $errorMessage.hashCode());
            return result;
        }

        public String toString() {
            return "ValidateResult.ErrorInfo(rowNum=" + this.getRowNum() + ", errorFieldName=" + this.getErrorFieldName() + ", errorMessage=" + this.getErrorMessage() + ")";
        }
    }
}

