package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 认证消息
 *
 * @author Bobo
 * @create 2024/6/22 14:49
 * @since 1.0.0
 */
public class AuthMessage {

    @Data
    public static class Request {

        /**
         * 授权人证件号码
         */
        private String idCard;

        /**
         * 授权人证件类型
         * 201 居民身份证
         * 208 外国护照
         * 210 港澳居民来往内地通行证
         * 213 台湾居民来往大陆通行证
         * 227 中国护照
         * 233 外国人永久居留证
         * 237 中华人民共和国港澳居民居住证
         * 238 中华人民共和国台湾居民居住证
         * 239 中华人民共和国外国人工作许可证（A类）
         * 240 中华人民共和国外国人工作许可证（B类）
         * 241 中华人民共和国外国人工作许可证（C类）
         * 299 其他个人证件
         */
        private String idCardType;

        /**
         * 自然人类型
         * 01 法定代表人
         * 02 财务负责人
         */
        private String relatedType;

        /**
         * 姓名
         */
        private String name;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        private String traceId;
        public Result result = new Result();

        @Data
        public static class Result {

            /**
             * 二维码内容
             * 二维码扫描成功后不返回null
             */
            private String qrCode;

            /**
             * 授权码
             * 二维码扫描成功后返回
             */
            private String authCode;

            /**
             * 授权码有效期止
             * 二维码扫描成功后返回
             * 格式: yyyy-MM-dd HH:mm:ss
             */
            private String endDate;

        }

    }
}
