package com.xforceplus.taxware.chestnut.contract.model;

import com.google.common.collect.Lists;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 发票xml文件下载
 *
 * @author zhouwen
 * @date 2023-03-14 17:35
 */
public class InvoiceXmlDownloadMessage {

    @Data
    public static class Request {

        private String env;

        private List<InvoiceDto> invoiceList;

        @Data
        public static class InvoiceDto {

            /**
             * pid
             */
            private String pid;

            /**
             * 发票代码
             * 非必填
             */
            private String invoiceNo;

            /**
             * 发票号码
             * 必填
             */
            private String invoiceCode;

            /**
             * 开票日期
             * 格式: yyyy-MM-dd HH:mm:ss
             * 必填
             */
            private String dateTimeIssued;

            /**
             * 销售方识别号
             * 非必填
             */
            private String sellerTaxNo;

            /**
             * 购买方识别号
             * 非必填
             */
            private String buyerTaxNo;

            /**
             * 申请人识别号
             * 必填
             */
            private String applyTaxNo;

            /**
             * 随机码
             */
            private String randomKey;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            private List<String> retryInvoiceNoList = Lists.newArrayList();

            private List<InvoiceXml> invoiceXmlList = Lists.newArrayList();

            @Data
            public static class InvoiceXml {

                /**
                 * pid
                 */
                private String pid;

                /**
                 * 发票号码
                 */
                private String invoiceNo;

                /**
                 * 数据类型
                 * key: 加密key
                 * stream: 文件流, zip+base64
                 */
                private String dataType;

                /**
                 * 数据
                 */
                private String data;

                /**
                 * 处理码
                 */
                private String processCode;

                /**
                 * 错误描述
                 */
                private String processMsg;
            }
        }
    }
}
