package com.xforceplus.taxware.chestnut.contract.model;

import com.xforceplus.taxware.chestnut.contract.model.constant.model.*;
import lombok.Data;

import javax.validation.constraints.NotEmpty;
import java.util.List;
import java.util.Map;

/**
 * @author Thj
 * @createdAt: 2024/3/2 11:20
 * @Description:
 */
public class LocalMakeInvoiceMessage {

    @Data
    public static class Request {
        /**
         * taskId
         */
        @NotEmpty
        private String taskId;

        private String issuer;

        private List<PreInvoice> preInvoiceList;
    }

    @Data
    public static class PreInvoice {

        /**
         * pid
         */
        @NotEmpty
        private String pid;

        /**
         * 租户Id
         */
        private String tenantId;

        private String invoiceType;
        private String invoiceStyleType;
        private String vatRefundType;
        private String settlementMode;
        private AeControl control;
        private AeSeller seller;
        private AeBuyer buyer;
        private AeNature nature;
        private AeOperator operator;
        private InvoiceAmount invoiceAmount;
        private RedLetter redLetter;
        private String remark;
        private List<InvoiceDetail> details;

        /**
         * 特定业务扩展要素
         */
        private List<Map<String, Object>> extraList;
    }
}
