package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 属地化 - 红字确认单操作
 *
 * @author zhouwen
 * @date 2024-03-14
 */
public class LocalRedLetterOperateMessage {

    @Data
    public static class Request {

        /**
         * pid
         */
        private String pid;

        /**
         * 税号
         */
        private String taxNo;

        /**
         * 红字确认单编号
         */
        private String redLetterNumber;

        /**
         * 确认状态
         */
        private String confirmStatus;

        /**
         * 操作身份
         */
        private String confirmIdentity;

        /**
         * 蓝字发票特定要素类型代码（非必须）
         * 01：成品油发票
         * 02：稀土发票
         * 03：建筑服务发票
         * 04：货物运输服务发票
         * 05：不动产销售服务发票
         * 06：不动产租赁服务发票
         * 07：代收车船税
         * 08：通行费
         * 09：旅客运输服务发票
         * 10：医疗服务（住院）发票
         * 11：医疗服务（门诊）发票
         * 12：自产农产品销售发票
         * 13 拖拉机和联合收割机发票
         * 14：机动车
         * 15：二手车
         * 16：农产品收购发票
         * 17：光伏收购发票
         * 18：卷烟发票
         */
        private String invoiceStyleType;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto{
        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * pid
             */
            private String pid;

            /**
             * 确认时间
             * 格式：yyyy-MM-dd HH:mm:ss
             */
            private String confirmTime;

            /**
             * 最新状态
             */
            private String latestStatus;
        }
    }
}