package com.xforceplus.taxware.chestnut.contract.model;

import com.xforceplus.taxware.chestnut.contract.model.page.PageDto;
import lombok.Data;

import java.util.List;

/**
 * 乐企配置消息
 *
 * @author Bobo
 * @create 2023/5/8 18:19
 * @since 1.0.0
 */
public class NsConfigMessage {

    @Data
    public static class Response {

        private String code = "1";
        private String message = "成功";
        private String traceId;

        private Result result = new Result();

        @Data
        public static class Result {
            private PageDto pageDto;
            private List<NsConfigDto> nsConfigDtoList;
        }

        @Data
        public static class NsConfigDto {

            /**
             * 税号
             */
            private String taxNo;

            /**
             * 公司名称
             */
            private String companyName;

            /**
             * 使用方平台编号
             */
            private String userPlatformNo;

            /**
             * 省级区域名称
             */
            private String areaName;

            /**
             * 省级区域代码
             */
            private String areaCode;

            /**
             * 能力编码集合
             */
            private List<String> capabilityCodeList;

            /**
             * 接入方平台税号
             */
            private String taxNoAccess;

            /**
             * 接入方平台编号
             */
            private String platformNo;

            /**
             * 使用单位登记序 号 20
             * 是
             */
            private String registerNo;

            /**
             * 邀请时间-时间格 式:”yyyy-MM-dd HH:mm:ss ”
             * 是
             */
            private String inviteTime;

            /**
             * 接入时间 -时间格 式:”yyyy-MM-dd HH:mm:ss ”
             * 是
             */
            private String accessTime;

            /**
             * 接入状态 2
             * 是
             */
            private String accessStatus;

            /**
             * 与直连单位关系
             * 是
             * 枚举值: 00-无关系、 01-总分公司 关系、 02-母子公司 关系、 03-其他控制 关系、04-不具有控 制关系、 05-同一监管 部门
             */
            private String relationshipType;
        }
    }
}
