package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Thj
 * @createdAt: 2024/3/24 16:10
 * @Description:
 */
@Data
public class NsInvoiceQueryResultMessage {
    @Data
    public static class Request {
        private List<String> pidList;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        private Result result = new Result();

        @Data
        public static class Result {
            private List<InvoiceQueryResult> invoiceList;

            @Data
            public static class InvoiceQueryResult {
                private String processStatus;
                private String processCode;
                private String processRemark;
                private String pid;
                private String invoiceNo;
                private String invoiceDate;
                private String remark;
            }
        }
    }
}
