package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.Date;

/**
 * 全电红字确认单确认
 */
public class RedLetterConfirmMessage {

    @Data
    public static class Request {

        /**
         * 流水号
         */
        private String taskId;

        /**
         * 租户id
         */
        private String tenantId;

        /**
         * 统一社会信用代码/纳税人识别号/身份证件号码
         */
        private String taxNo;

        /**
         * 红字确认单编号
         */
        private String redLetterNumber;

        /**
         * 确认类型
         * Y：同意
         * N：不同意
         * C：撤销
         */
        private String confirmStatus;

        /**
         * 操作身份
         * 0: 销方
         * 1: 购方
         */
        private String confirmIdentity;

        /**
         * 蓝字发票特定要素类型代码（非必须）
         * 01：成品油发票
         * 02：稀土发票
         * 03：建筑服务发票
         * 04：货物运输服务发票
         * 05：不动产销售服务发票
         * 06：不动产租赁服务发票
         * 07：代收车船税
         * 08：通行费
         * 09：旅客运输服务发票
         * 10：医疗服务（住院）发票
         * 11：医疗服务（门诊）发票
         * 12：自产农产品销售发票
         * 13 拖拉机和联合收割机发票
         * 14：机动车
         * 15：二手车
         * 16：农产品收购发票
         * 17：光伏收购发票
         * 18：卷烟发票
         */
        private String invoiceStyleType;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 流水号
             */
            private String taskId;

            /**
             * 租户id
             */
            private String tenantId;

            /**
             * 确认日期（非必须）
             * yyyy-MM-dd HH:mm:ss
             */
            private String confirmTime;

            /**
             * 最新状态
             */
            private String latestStatus;
        }
    }
}
