package com.xforceplus.taxware.chestnut.contract.model;

import com.google.common.collect.Lists;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 查询全电红字确认单明细信息
 */
public class RedLetterDetailMessage {

    @Data
    public static class Request {

        /**
         * 红字确认单UUID
         */
        private String redLetterUuid;

        /**
         * （销售方）统一社会信用代码/纳税人识别号/身份证件号码
         */
        private String sellerTaxNo;
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 红字确认单UUID
             */
            private String redLetterUuid;

            /**
             * 红字发票信息确认单编号
             */
            private String redLetterNumber;

            /**
             * 录入方身份
             * 0：销方
             * 1：购方
             */
            private String applyIdentity;

            /**
             * 销方信息
             */
            private SellerDto sellerDto;

            /**
             * 购方信息
             */
            private BuyerDto buyerDto;

            /**
             * 原蓝票信息
             */
            private OriginalInvoiceDto originalInvoiceDto;

            /**
             * 红字发票信息
             */
            private ReverseInvoiceDto reverseInvoiceDto;

            /**
             * 红字发票冲红原因代码
             * 01：开票有误
             * 02：销货退回
             * 03：服务中止
             * 04：销售折让
             */
            private String applyReason;

            /**
             * 红字确认单状态
             * 01：无需确认
             * 02：销方录入待购方确认
             * 03：购方录入待销方确认
             * 04：购销双方已确认
             * 05：作废（销方录入购方否认）
             * 06：作废（购方录入销方否认）
             * 07：作废（超72小时未确认）
             * 08：（发起方撤销）
             * 09：作废（确认后撤销）
             * 10作废（异常凭证）
             */
            private String redLetterStatus;

            /**
             * 确认日期（非必须）
             * yyyy-MM-dd HH:mm:ss
             */
            private Date confirmTime;

            /**
             * 已开具红字发票标志（非必须）
             * Y：已开具
             * N：未开具
             */
            private String issuedFlag;

            /**
             * 有效标志
             * Y：有效
             * N：无效
             */
            private String validFlag;

            /**
             * 明细
             */
            private List<Detail> details = Lists.newArrayList();

            @Data
            public static class Detail {

                /**
                 * 序号
                 * 8位，从1开始。
                 */
                private Integer rowNum;

                /**
                 * 蓝字发票明细序号（非必须）
                 */
                private Integer originalRowNum;

                /**
                 * 商品和服务税收分类合并编码
                 */
                private String goodsTaxNo;

                /**
                 * 货物或应税劳务、服务名称
                 */
                private String itemSimpleName;

                /**
                 * 商品服务简称
                 */
                private String itemShortName;

                /**
                 * 项目名称
                 */
                private String itemName;

                /**
                 * 规格型号（非必须）
                 */
                private String specifications;

                /**
                 * 单位（非必须）
                 * 如“数量”“单价”栏次非空，则本栏次必须非空
                 */
                private String unit;

                /**
                 * 单价（非必须）
                 * 如“数量”“单位”栏次非空，则本栏次必须非空
                 */
                private String unitPrice;

                /**
                 * 数量（非必须）
                 * 如“单价”“单价”栏次非空，则本栏次必须非空
                 */
                private String quantity;

                /**
                 * 金额
                 */
                private BigDecimal amountWithoutTax;

                /**
                 * 税率
                 */
                private BigDecimal taxRate;

                /**
                 * 税额
                 */
                private BigDecimal taxAmount;
            }

            @Data
            public static class SellerDto {

                /**
                 * （销售方）统一社会信用代码/纳税人识别号/身份证件号码
                 */
                private String sellerTaxNo;

                /**
                 * （销售方）名称
                 */
                private String sellerName;
            }

            @Data
            public static class BuyerDto {

                /**
                 * （购买方）统一社会信用代码/纳税人识别号/身份证件号码（非必须）
                 */
                private String buyerTaxNo;

                /**
                 * （购买方）名称
                 */
                private String buyerName;
            }

            @Data
            public static class OriginalInvoiceDto {

                /**
                 * 蓝字发票代码（非必须）
                 */
                private Integer originalInvoiceCode;

                /**
                 * 蓝字发票号码（非必须）
                 */
                private Integer originalInvoiceNo;

                /**
                 * 是否纸质发票标志
                 * Y：纸质发票
                 * N：电子发票
                 */
                private String paperInvoiceFlag;

                /**
                 * 蓝字发票开票日期（非必须）
                 * yyyy-MM-dd HH:mm:ss
                 */
                private Date originalDateTimeIssued;

                /**
                 * 蓝字发票合计金额（非必须）
                 */
                private BigDecimal originalAmountWithoutTax;

                /**
                 * 蓝字发票合计税额（非必须）
                 */
                private BigDecimal originalTaxAmount;

                /**
                 * 蓝字发票票种代码（非必须）
                 * 01: 增值税专用发票
                 * 02: 普通发票
                 * 03: 机动车统一销售发票
                 * 04: 二手车统一销售发票
                 */
                private String originalInvoiceType;

                /**
                 * 蓝字发票特定要素类型代码（非必须）
                 * 01：成品油发票
                 * 02：稀土发票
                 * 03：建筑服务发票
                 * 04：货物运输服务发票
                 * 05：不动产销售服务发票
                 * 06：不动产租赁服务发票
                 * 07：代收车船税
                 * 08：通行费
                 * 09：旅客运输服务发票
                 * 10：医疗服务（住院）发票
                 * 11：医疗服务（门诊）发票
                 * 12：自产农产品销售发票
                 * 13	拖拉机和联合收割机发票
                 * 14：机动车
                 * 15：二手车
                 * 16：农产品收购发票
                 * 17：光伏收购发票
                 * 18：卷烟发票
                 */
                private String originalInvoiceStyleType;
            }

            @Data
            public static class ReverseInvoiceDto {

                /**
                 * 红字冲销金额
                 */
                private BigDecimal reverseAmountWithoutTax;

                /**
                 * 红字冲销税额
                 */
                private BigDecimal reverseTaxAmount;

                /**
                 * 红字发票号码
                 */
                private String redInvoiceNo;

                /**
                 * 红字开票日期
                 * yyyy-MM-dd HH:mm:ss
                 */
                private Date redDateTimeIssued;
            }
        }
    }
}
