package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 查询全电红字确认单列表信息
 */
public class RedLetterSyncDetailMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 红字确认单明细列表
             */
            private List<RedLetterDetail> detailList;

            @Data
            public static class RedLetterDetail {

                /**
                 * 蓝字发票明细序号（非必须）
                 */
                private Integer originInvoiceRowNum;

                /**
                 * 序号从1开始
                 */
                private Integer rowNum;

                /**
                 *
                 */
                private DetailAmount detailAmount;

                @Data
                public static class DetailAmount {

                    /**
                     * 明细不含税金额
                     */
                    private BigDecimal amountWithoutTax;

                    /**
                     * 数量，小数位不超过13位
                     */
                    private BigDecimal quantity;

                    /**
                     * 单价，小数位不超过13位
                     */
                    private BigDecimal unitPrice;

                    /**
                     * 税额
                     */
                    private BigDecimal taxAmount;

                }

                /**
                 *
                 */
                private Item item;

                @Data
                public static class Item {

                    /**
                     * 商品名称
                     */
                    private String itemName;

                    /**
                     * 规格型号
                     */
                    private String specifications;

                    /**
                     * 单位
                     */
                    private String unit;

                }

                /**
                 *
                 */
                private Tax tax;

                @Data
                public static class Tax {

                    /**
                     * 税率
                     */
                    private BigDecimal taxRate;

                    /**
                     * 税收信息
                     */
                    private String taxClassCode;


                }
            }
        }
    }
}
