package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 纳税人基本信息查询
 *
 * @author zhouwen
 * @date 2023-10-25
 */
public class TaxCodeQueryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {
            List<TaxCodeDto> taxCodeList;
        }

        @Data
        public static class TaxCodeDto {
            private String parentCode;
            private String goodsTaxNo;
            private String invoiceStyleType;
            private String deduction;
            private String taxPreFlag;
            private String itemSimpleName;
            private String itemShortName;
            private String taxRate;
            private String specialManagement;
            private String summarizeItemFlag;
        }
    }
}
