package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 纳税人基本信息查询
 *
 * @author zhouwen
 * @date 2023-10-25
 */
public class TaxpayerInfoQueryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private TaxpayerInfoDto result;

        @Data
        public static class TaxpayerInfoDto {
            private String taxNo;
            private String taxpayerName;
            private String taxpayerTypeTag;
            private String countyTaxAuthorityCode;
            private String chargeTaxDepartmentCode;
            private String chargeTaxDepartmentName;
            private String allElectricFlag;
            private String exportEnterprisesType;
            private String industryNatureProperties;
            private String exciseTaxpayerType;
        }
    }
}
