package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 企业基础信息查询
 * 包含: 纳税人信息 + 纳税人风险信息 + 平台编号 等
 *
 * @author zhouwen
 * @date 2023-10-30 13:43
 */
public class TaxwareBaseInfoMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        public Result result = new Result();

        @Data
        public static class Result {

            /**
             * 税号
             */
            private String taxNo;

            /**
             * 公司名称
             */
            private String companyName;

            /**
             * 平台编号
             */
            private String platformNo;

            /**
             * 纳税人类型
             */
            private String taxpayerType;

            /**
             * 纳税人信用等级
             */
            private String taxpayerCreditRating;

            /**
             * 风险纳税人类型
             */
            private String taxpayerRiskType;

            /**
             * 出口企业分类
             */
            private String exportEnterprisesType;

            /**
             * 出口企业分类
             */
            private List<String> industryNaturePropertiesList;

            /**
             * 消费税纳税人类型
             */
            private List<String> exciseTaxpayerTypeList;

        }
    }
}
