package com.xforceplus.taxware.chestnut.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * 使用单位接入信息
 *
 * @author lv
 * @create 2024/6/22 14:49
 * @since 1.0.0
 */
public class UnitAccessMessage {

    @Data
    public static class Request {

        /**
         * 页码（必须）
         */
        private Integer pageNumber = 1;

        /**
         * 每页数量（必须）
         * 分页查询-待 查询页大小 大于等于 1 且 小于等于 100 的整数
         */
        private Integer pageSize = 100;

        /**
         * 接入状态
         * 否
         */
        private String accessStatus;

        /**
         * 使用单位信息
         * 否
         */
        private List<UseUnit> useUnits;

        @Data
        public static class UseUnit {

            /**
             * 使用单位纳税人 识别号/统一社会 信用代码
             * 20
             * 是
             */
            private String taxNo;

            /**
             * 省市级税务机关 代码
             * 20
             * 是
             */
            private String provincialTaxAuthorityCode;
        }
    }

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {
        private String traceId;
        public Object result ;
    }
}
