package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import java.util.Objects;

/**
 * @author Thj
 * @createdAt: 2023/3/1 14:25
 * @Description:
 */
public enum AeProcessStatusEnum {

    /**
     * 初始化
     */
    ORIGINAL("0", "ORIGINAl"),

    /**
     * 开具成功
     */
    SUCCESSFUL("1", "SUCCESS"),

    /**
     * 上传中
     */
    INPROGRESS("2", "IN_PROGRESS"),

    /**
     * 开具失败
     */
    FAIL("3", "FAILED"),

    /**
     * 校验失败
     */
    VALIDATION_FAIL("4", "VALIDATION_FAILED"),

    /**
     * 网络异常
     */
    HTTP_EXCEPTION("5", "HTTP_EXCEPTION"),

    /**
     * 重试超限
     */
    RETRY_OVERFLOW("6", "RETRY_OVERFLOW"),

    /**
     * 其他异常
     */
    EXCEPTION("7", "EXCEPTION");

    private String code;
    private String message;

    AeProcessStatusEnum(String code, String message) {
        this.code = code;
        this.message = message;
    }

    public static AeProcessStatusEnum fromCode(String code) {
        final AeProcessStatusEnum[] values = AeProcessStatusEnum.values();

        for (AeProcessStatusEnum item : values) {
            if (item.code.equals(code)) {
                return item;
            }
        }

        return null;
    }

    public static AeProcessStatusEnum fromMessage(String message) {
        final AeProcessStatusEnum[] values = AeProcessStatusEnum.values();

        for (AeProcessStatusEnum item : values) {
            if (Objects.equals(item.message, message)) {
                return item;
            }
        }

        return null;
    }

    public String toCode() {
        return code;
    }

    public String toMessage() {
        return message;
    }
}
