package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import java.util.Arrays;
import java.util.Objects;

/**
 * @author zhenmengying
 * @date 2023/3/1
 * @describe:
 */
public enum TaxCodeStatusEnum {

    /**
     * 税编是否汇总项
     */
    TAX_RATE_STATUS("", "是否汇总项"),
    TAX_RATE_STATUS_Y("Y", "是"),
    TAX_RATE_STATUS_N("N", "否");

    /**
     * 成员变量
     */
    private String status;
    private String statusDesc;

    /**
     * 构造方法
     */
    TaxCodeStatusEnum(String status, String statusDesc) {
        this.status = status;
        this.statusDesc = statusDesc;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public static TaxCodeStatusEnum fromStatus(String status) {

        return Arrays.stream(TaxCodeStatusEnum.values())
                .filter(value -> Objects.equals(value.status, status))
                .findAny().orElse(null);

    }
}
