package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Auther lv
 * @Date 2023/2/20
 */
public enum TaxpayerRiskFlagEnum {

    /**
     * 风险纳税人标志
     * Y：风险纳税人
     * N：正常纳税人
     */
    TAXPAYER_RISK_FLAG_Y("Y", "风险纳税人"),
    TAXPAYER_RISK_FLAG_N("N", "正常纳税人");


    /**
     * 成员变量
     */
    private String status;
    private String statusDesc;

    /**
     * 构造方法
     */
    TaxpayerRiskFlagEnum(String status, String statusDesc) {
        this.status = status;
        this.statusDesc = statusDesc;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public static TaxpayerRiskFlagEnum fromStatus(String status) {

        return Arrays.stream(TaxpayerRiskFlagEnum.values())
                .filter(value -> Objects.equals(value.status, status))
                .findAny().orElse(null);

    }
}
