package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import org.jetbrains.annotations.NotNull;

import java.util.Arrays;
import java.util.Objects;

/**
 * @Auther lv
 * @Date 2023/2/20
 */
public enum TaxpayerWarningLevelEnum {

    /**
     * 纳税人预警级别（非必须）
     */
    TAXPAYER_WARNING_LEVEL("", "无预警"),
    TAXPAYER_WARNING_LEVEL_01("01", "红色预警"),
    TAXPAYER_WARNING_LEVEL_02("02", "黄色预警"),
    TAXPAYER_WARNING_LEVEL_03("03", "蓝色预警");

    /**
     * 成员变量
     */
    private String status;
    private String statusDesc;

    /**
     * 构造方法
     */
    TaxpayerWarningLevelEnum(String status, String statusDesc) {
        this.status = status;
        this.statusDesc = statusDesc;
    }

    public String getStatus() {
        return status;
    }

    public String getStatusDesc() {
        return statusDesc;
    }

    public static TaxpayerWarningLevelEnum fromStatus(String status) {

        return Arrays.stream(TaxpayerWarningLevelEnum.values())
                .filter(value -> Objects.equals(value.status, status))
                .findAny().orElse(null);

    }
}
