package com.xforceplus.taxware.chestnut.contract.model.openapi;

import com.xforceplus.taxware.chestnut.contract.model.BaseResponseDto;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * <a href="https://api-mock.xforceplus.com/project/703/interface/api/44340">...</a>
 * 发票汇总上传数据查询
 *
 * @author Bobo
 * @create 2024/11/14 16:00
 * @since 1.0.0
 */
public class QueryOpenApiSummaryMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        public Result result = new Result();

        @Data
        public static class Result {

            /**
             * 税号
             */
            private String taxNo;

            /**
             * 属期（格式：yyyy-MM）
             */
            private String period;

            /**
             * 蓝票开具数量
             */
            private Integer blueInvoiceNum;

            /**
             * 蓝票开具不含税金额
             */
            private String blueAmountWithoutTax;

            /**
             * 蓝票开具含税金额
             */
            private String blueAmountTax;

            /**
             * 红票开具数量
             */
            private Integer redInvoiceNum;

            /**
             * 红票开具不含税金额
             */
            private String redAmountWithoutTax;

            /**
             * 红票开具含税金额
             */
            private String redAmountTax;

        }
    }
}
