/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.contract.model;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Digits;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Pattern;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.ScriptAssert;

public class MakeInvoiceMessage {

    public static class InvoiceInfo {
        @NotEmpty
        private String pid;
        private String tenantId;
        @NotEmpty
        @Length(max=1)
        @Pattern(regexp="0|1")
        private @NotEmpty @Length(max=1) @Pattern(regexp="0|1") String invoiceFlag;
        @NotEmpty
        @Length(max=2)
        @Pattern(regexp="0[1-2]")
        private @NotEmpty @Length(max=2) @Pattern(regexp="0[1-2]") String invoiceType;
        @Length(max=2)
        @Pattern(regexp="0[1-9]|1[0-8]")
        private @Length(max=2) @Pattern(regexp="0[1-9]|1[0-8]") String invoiceStyleType;
        @Length(max=2)
        @Pattern(regexp="0[1-9]|1[0-2]")
        private @Length(max=2) @Pattern(regexp="0[1-9]|1[0-2]") String vatRefundType;
        @NotEmpty
        @Length(max=20)
        @Pattern(regexp="[A-Z0-9]+")
        private @NotEmpty @Length(max=20) @Pattern(regexp="[A-Z0-9]+") String sellerTaxNo;
        @NotEmpty
        @Length(max=300)
        private @NotEmpty @Length(max=300) String sellerName;
        @Length(max=300)
        private @Length(max=300) String sellerAddress;
        @Length(max=60)
        private @Length(max=60) String sellerTel;
        @Length(max=120)
        private @Length(max=120) String sellerBankName;
        @Length(max=100)
        private @Length(max=100) String sellerBankAccount;
        @Length(max=20)
        @Pattern(regexp="[A-Z0-9]+")
        private @Length(max=20) @Pattern(regexp="[A-Z0-9]+") String buyerTaxNo;
        @NotEmpty
        @Length(max=300)
        private @NotEmpty @Length(max=300) String buyerName;
        @Length(max=300)
        private @Length(max=300) String buyerAddress;
        @Length(max=60)
        private @Length(max=60) String buyerTel;
        @Length(max=120)
        private @Length(max=120) String buyerBankName;
        @Length(max=100)
        private @Length(max=100) String buyerBankAccount;
        @Length(max=150)
        private @Length(max=150) String buyerOperatorName;
        @Length(max=30)
        private @Length(max=30) String buyerOperatorIdentityNo;
        @Length(max=60)
        private @Length(max=60) String buyerOperatorTel;
        private Boolean isNature = false;
        @NotNull
        @Digits(integer=18, fraction=2)
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithoutTax;
        @NotNull
        @Digits(integer=18, fraction=2)
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal taxAmount;
        @NotNull
        @Digits(integer=18, fraction=2)
        private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithTax;
        @Length(max=120)
        private @Length(max=120) String payeeBankName;
        @Length(max=100)
        private @Length(max=100) String payeeBankAccount;
        @Length(max=2)
        @Pattern(regexp="0[1-5]|99")
        private @Length(max=2) @Pattern(regexp="0[1-5]|99") String settlementMode;
        @NotEmpty
        @Length(max=300)
        private @NotEmpty @Length(max=300) String issuer;
        @Length(max=150)
        private @Length(max=150) String payee;
        @Length(max=75)
        private @Length(max=75) String reviewer;
        @Length(max=30)
        private @Length(max=30) String issuerIdentityNo;
        @Length(max=4)
        private @Length(max=4) String issuerIdentityType;
        @Length(max=20)
        private @Length(max=20) String originalInvoiceNo;
        @Length(max=20)
        private @Length(max=20) String redLetterNumber;
        @Length(max=32)
        private @Length(max=32) String redLetterUuid;
        @Length(max=450)
        private @Length(max=450) String remark;
        private Boolean showBuyerBankControl = false;
        private Boolean showSellerBankControl = false;
        private List<InvoiceDetail> invoiceDetailList;
        private List<Map<String, Object>> extraList;

        public String getPid() {
            return this.pid;
        }

        public String getTenantId() {
            return this.tenantId;
        }

        public String getInvoiceFlag() {
            return this.invoiceFlag;
        }

        public String getInvoiceType() {
            return this.invoiceType;
        }

        public String getInvoiceStyleType() {
            return this.invoiceStyleType;
        }

        public String getVatRefundType() {
            return this.vatRefundType;
        }

        public String getSellerTaxNo() {
            return this.sellerTaxNo;
        }

        public String getSellerName() {
            return this.sellerName;
        }

        public String getSellerAddress() {
            return this.sellerAddress;
        }

        public String getSellerTel() {
            return this.sellerTel;
        }

        public String getSellerBankName() {
            return this.sellerBankName;
        }

        public String getSellerBankAccount() {
            return this.sellerBankAccount;
        }

        public String getBuyerTaxNo() {
            return this.buyerTaxNo;
        }

        public String getBuyerName() {
            return this.buyerName;
        }

        public String getBuyerAddress() {
            return this.buyerAddress;
        }

        public String getBuyerTel() {
            return this.buyerTel;
        }

        public String getBuyerBankName() {
            return this.buyerBankName;
        }

        public String getBuyerBankAccount() {
            return this.buyerBankAccount;
        }

        public String getBuyerOperatorName() {
            return this.buyerOperatorName;
        }

        public String getBuyerOperatorIdentityNo() {
            return this.buyerOperatorIdentityNo;
        }

        public String getBuyerOperatorTel() {
            return this.buyerOperatorTel;
        }

        public Boolean getIsNature() {
            return this.isNature;
        }

        public BigDecimal getAmountWithoutTax() {
            return this.amountWithoutTax;
        }

        public BigDecimal getTaxAmount() {
            return this.taxAmount;
        }

        public BigDecimal getAmountWithTax() {
            return this.amountWithTax;
        }

        public String getPayeeBankName() {
            return this.payeeBankName;
        }

        public String getPayeeBankAccount() {
            return this.payeeBankAccount;
        }

        public String getSettlementMode() {
            return this.settlementMode;
        }

        public String getIssuer() {
            return this.issuer;
        }

        public String getPayee() {
            return this.payee;
        }

        public String getReviewer() {
            return this.reviewer;
        }

        public String getIssuerIdentityNo() {
            return this.issuerIdentityNo;
        }

        public String getIssuerIdentityType() {
            return this.issuerIdentityType;
        }

        public String getOriginalInvoiceNo() {
            return this.originalInvoiceNo;
        }

        public String getRedLetterNumber() {
            return this.redLetterNumber;
        }

        public String getRedLetterUuid() {
            return this.redLetterUuid;
        }

        public String getRemark() {
            return this.remark;
        }

        public Boolean getShowBuyerBankControl() {
            return this.showBuyerBankControl;
        }

        public Boolean getShowSellerBankControl() {
            return this.showSellerBankControl;
        }

        public List<InvoiceDetail> getInvoiceDetailList() {
            return this.invoiceDetailList;
        }

        public List<Map<String, Object>> getExtraList() {
            return this.extraList;
        }

        public void setPid(String pid) {
            this.pid = pid;
        }

        public void setTenantId(String tenantId) {
            this.tenantId = tenantId;
        }

        public void setInvoiceFlag(String invoiceFlag) {
            this.invoiceFlag = invoiceFlag;
        }

        public void setInvoiceType(String invoiceType) {
            this.invoiceType = invoiceType;
        }

        public void setInvoiceStyleType(String invoiceStyleType) {
            this.invoiceStyleType = invoiceStyleType;
        }

        public void setVatRefundType(String vatRefundType) {
            this.vatRefundType = vatRefundType;
        }

        public void setSellerTaxNo(String sellerTaxNo) {
            this.sellerTaxNo = sellerTaxNo;
        }

        public void setSellerName(String sellerName) {
            this.sellerName = sellerName;
        }

        public void setSellerAddress(String sellerAddress) {
            this.sellerAddress = sellerAddress;
        }

        public void setSellerTel(String sellerTel) {
            this.sellerTel = sellerTel;
        }

        public void setSellerBankName(String sellerBankName) {
            this.sellerBankName = sellerBankName;
        }

        public void setSellerBankAccount(String sellerBankAccount) {
            this.sellerBankAccount = sellerBankAccount;
        }

        public void setBuyerTaxNo(String buyerTaxNo) {
            this.buyerTaxNo = buyerTaxNo;
        }

        public void setBuyerName(String buyerName) {
            this.buyerName = buyerName;
        }

        public void setBuyerAddress(String buyerAddress) {
            this.buyerAddress = buyerAddress;
        }

        public void setBuyerTel(String buyerTel) {
            this.buyerTel = buyerTel;
        }

        public void setBuyerBankName(String buyerBankName) {
            this.buyerBankName = buyerBankName;
        }

        public void setBuyerBankAccount(String buyerBankAccount) {
            this.buyerBankAccount = buyerBankAccount;
        }

        public void setBuyerOperatorName(String buyerOperatorName) {
            this.buyerOperatorName = buyerOperatorName;
        }

        public void setBuyerOperatorIdentityNo(String buyerOperatorIdentityNo) {
            this.buyerOperatorIdentityNo = buyerOperatorIdentityNo;
        }

        public void setBuyerOperatorTel(String buyerOperatorTel) {
            this.buyerOperatorTel = buyerOperatorTel;
        }

        public void setIsNature(Boolean isNature) {
            this.isNature = isNature;
        }

        public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
            this.amountWithoutTax = amountWithoutTax;
        }

        public void setTaxAmount(BigDecimal taxAmount) {
            this.taxAmount = taxAmount;
        }

        public void setAmountWithTax(BigDecimal amountWithTax) {
            this.amountWithTax = amountWithTax;
        }

        public void setPayeeBankName(String payeeBankName) {
            this.payeeBankName = payeeBankName;
        }

        public void setPayeeBankAccount(String payeeBankAccount) {
            this.payeeBankAccount = payeeBankAccount;
        }

        public void setSettlementMode(String settlementMode) {
            this.settlementMode = settlementMode;
        }

        public void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        public void setPayee(String payee) {
            this.payee = payee;
        }

        public void setReviewer(String reviewer) {
            this.reviewer = reviewer;
        }

        public void setIssuerIdentityNo(String issuerIdentityNo) {
            this.issuerIdentityNo = issuerIdentityNo;
        }

        public void setIssuerIdentityType(String issuerIdentityType) {
            this.issuerIdentityType = issuerIdentityType;
        }

        public void setOriginalInvoiceNo(String originalInvoiceNo) {
            this.originalInvoiceNo = originalInvoiceNo;
        }

        public void setRedLetterNumber(String redLetterNumber) {
            this.redLetterNumber = redLetterNumber;
        }

        public void setRedLetterUuid(String redLetterUuid) {
            this.redLetterUuid = redLetterUuid;
        }

        public void setRemark(String remark) {
            this.remark = remark;
        }

        public void setShowBuyerBankControl(Boolean showBuyerBankControl) {
            this.showBuyerBankControl = showBuyerBankControl;
        }

        public void setShowSellerBankControl(Boolean showSellerBankControl) {
            this.showSellerBankControl = showSellerBankControl;
        }

        public void setInvoiceDetailList(List<InvoiceDetail> invoiceDetailList) {
            this.invoiceDetailList = invoiceDetailList;
        }

        public void setExtraList(List<Map<String, Object>> extraList) {
            this.extraList = extraList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InvoiceInfo)) {
                return false;
            }
            InvoiceInfo other = (InvoiceInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$pid = this.getPid();
            String other$pid = other.getPid();
            if (this$pid == null ? other$pid != null : !this$pid.equals(other$pid)) {
                return false;
            }
            String this$tenantId = this.getTenantId();
            String other$tenantId = other.getTenantId();
            if (this$tenantId == null ? other$tenantId != null : !this$tenantId.equals(other$tenantId)) {
                return false;
            }
            String this$invoiceFlag = this.getInvoiceFlag();
            String other$invoiceFlag = other.getInvoiceFlag();
            if (this$invoiceFlag == null ? other$invoiceFlag != null : !this$invoiceFlag.equals(other$invoiceFlag)) {
                return false;
            }
            String this$invoiceType = this.getInvoiceType();
            String other$invoiceType = other.getInvoiceType();
            if (this$invoiceType == null ? other$invoiceType != null : !this$invoiceType.equals(other$invoiceType)) {
                return false;
            }
            String this$invoiceStyleType = this.getInvoiceStyleType();
            String other$invoiceStyleType = other.getInvoiceStyleType();
            if (this$invoiceStyleType == null ? other$invoiceStyleType != null : !this$invoiceStyleType.equals(other$invoiceStyleType)) {
                return false;
            }
            String this$vatRefundType = this.getVatRefundType();
            String other$vatRefundType = other.getVatRefundType();
            if (this$vatRefundType == null ? other$vatRefundType != null : !this$vatRefundType.equals(other$vatRefundType)) {
                return false;
            }
            String this$sellerTaxNo = this.getSellerTaxNo();
            String other$sellerTaxNo = other.getSellerTaxNo();
            if (this$sellerTaxNo == null ? other$sellerTaxNo != null : !this$sellerTaxNo.equals(other$sellerTaxNo)) {
                return false;
            }
            String this$sellerName = this.getSellerName();
            String other$sellerName = other.getSellerName();
            if (this$sellerName == null ? other$sellerName != null : !this$sellerName.equals(other$sellerName)) {
                return false;
            }
            String this$sellerAddress = this.getSellerAddress();
            String other$sellerAddress = other.getSellerAddress();
            if (this$sellerAddress == null ? other$sellerAddress != null : !this$sellerAddress.equals(other$sellerAddress)) {
                return false;
            }
            String this$sellerTel = this.getSellerTel();
            String other$sellerTel = other.getSellerTel();
            if (this$sellerTel == null ? other$sellerTel != null : !this$sellerTel.equals(other$sellerTel)) {
                return false;
            }
            String this$sellerBankName = this.getSellerBankName();
            String other$sellerBankName = other.getSellerBankName();
            if (this$sellerBankName == null ? other$sellerBankName != null : !this$sellerBankName.equals(other$sellerBankName)) {
                return false;
            }
            String this$sellerBankAccount = this.getSellerBankAccount();
            String other$sellerBankAccount = other.getSellerBankAccount();
            if (this$sellerBankAccount == null ? other$sellerBankAccount != null : !this$sellerBankAccount.equals(other$sellerBankAccount)) {
                return false;
            }
            String this$buyerTaxNo = this.getBuyerTaxNo();
            String other$buyerTaxNo = other.getBuyerTaxNo();
            if (this$buyerTaxNo == null ? other$buyerTaxNo != null : !this$buyerTaxNo.equals(other$buyerTaxNo)) {
                return false;
            }
            String this$buyerName = this.getBuyerName();
            String other$buyerName = other.getBuyerName();
            if (this$buyerName == null ? other$buyerName != null : !this$buyerName.equals(other$buyerName)) {
                return false;
            }
            String this$buyerAddress = this.getBuyerAddress();
            String other$buyerAddress = other.getBuyerAddress();
            if (this$buyerAddress == null ? other$buyerAddress != null : !this$buyerAddress.equals(other$buyerAddress)) {
                return false;
            }
            String this$buyerTel = this.getBuyerTel();
            String other$buyerTel = other.getBuyerTel();
            if (this$buyerTel == null ? other$buyerTel != null : !this$buyerTel.equals(other$buyerTel)) {
                return false;
            }
            String this$buyerBankName = this.getBuyerBankName();
            String other$buyerBankName = other.getBuyerBankName();
            if (this$buyerBankName == null ? other$buyerBankName != null : !this$buyerBankName.equals(other$buyerBankName)) {
                return false;
            }
            String this$buyerBankAccount = this.getBuyerBankAccount();
            String other$buyerBankAccount = other.getBuyerBankAccount();
            if (this$buyerBankAccount == null ? other$buyerBankAccount != null : !this$buyerBankAccount.equals(other$buyerBankAccount)) {
                return false;
            }
            String this$buyerOperatorName = this.getBuyerOperatorName();
            String other$buyerOperatorName = other.getBuyerOperatorName();
            if (this$buyerOperatorName == null ? other$buyerOperatorName != null : !this$buyerOperatorName.equals(other$buyerOperatorName)) {
                return false;
            }
            String this$buyerOperatorIdentityNo = this.getBuyerOperatorIdentityNo();
            String other$buyerOperatorIdentityNo = other.getBuyerOperatorIdentityNo();
            if (this$buyerOperatorIdentityNo == null ? other$buyerOperatorIdentityNo != null : !this$buyerOperatorIdentityNo.equals(other$buyerOperatorIdentityNo)) {
                return false;
            }
            String this$buyerOperatorTel = this.getBuyerOperatorTel();
            String other$buyerOperatorTel = other.getBuyerOperatorTel();
            if (this$buyerOperatorTel == null ? other$buyerOperatorTel != null : !this$buyerOperatorTel.equals(other$buyerOperatorTel)) {
                return false;
            }
            Boolean this$isNature = this.getIsNature();
            Boolean other$isNature = other.getIsNature();
            if (this$isNature == null ? other$isNature != null : !((Object)this$isNature).equals(other$isNature)) {
                return false;
            }
            BigDecimal this$amountWithoutTax = this.getAmountWithoutTax();
            BigDecimal other$amountWithoutTax = other.getAmountWithoutTax();
            if (this$amountWithoutTax == null ? other$amountWithoutTax != null : !((Object)this$amountWithoutTax).equals(other$amountWithoutTax)) {
                return false;
            }
            BigDecimal this$taxAmount = this.getTaxAmount();
            BigDecimal other$taxAmount = other.getTaxAmount();
            if (this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount)) {
                return false;
            }
            BigDecimal this$amountWithTax = this.getAmountWithTax();
            BigDecimal other$amountWithTax = other.getAmountWithTax();
            if (this$amountWithTax == null ? other$amountWithTax != null : !((Object)this$amountWithTax).equals(other$amountWithTax)) {
                return false;
            }
            String this$payeeBankName = this.getPayeeBankName();
            String other$payeeBankName = other.getPayeeBankName();
            if (this$payeeBankName == null ? other$payeeBankName != null : !this$payeeBankName.equals(other$payeeBankName)) {
                return false;
            }
            String this$payeeBankAccount = this.getPayeeBankAccount();
            String other$payeeBankAccount = other.getPayeeBankAccount();
            if (this$payeeBankAccount == null ? other$payeeBankAccount != null : !this$payeeBankAccount.equals(other$payeeBankAccount)) {
                return false;
            }
            String this$settlementMode = this.getSettlementMode();
            String other$settlementMode = other.getSettlementMode();
            if (this$settlementMode == null ? other$settlementMode != null : !this$settlementMode.equals(other$settlementMode)) {
                return false;
            }
            String this$issuer = this.getIssuer();
            String other$issuer = other.getIssuer();
            if (this$issuer == null ? other$issuer != null : !this$issuer.equals(other$issuer)) {
                return false;
            }
            String this$payee = this.getPayee();
            String other$payee = other.getPayee();
            if (this$payee == null ? other$payee != null : !this$payee.equals(other$payee)) {
                return false;
            }
            String this$reviewer = this.getReviewer();
            String other$reviewer = other.getReviewer();
            if (this$reviewer == null ? other$reviewer != null : !this$reviewer.equals(other$reviewer)) {
                return false;
            }
            String this$issuerIdentityNo = this.getIssuerIdentityNo();
            String other$issuerIdentityNo = other.getIssuerIdentityNo();
            if (this$issuerIdentityNo == null ? other$issuerIdentityNo != null : !this$issuerIdentityNo.equals(other$issuerIdentityNo)) {
                return false;
            }
            String this$issuerIdentityType = this.getIssuerIdentityType();
            String other$issuerIdentityType = other.getIssuerIdentityType();
            if (this$issuerIdentityType == null ? other$issuerIdentityType != null : !this$issuerIdentityType.equals(other$issuerIdentityType)) {
                return false;
            }
            String this$originalInvoiceNo = this.getOriginalInvoiceNo();
            String other$originalInvoiceNo = other.getOriginalInvoiceNo();
            if (this$originalInvoiceNo == null ? other$originalInvoiceNo != null : !this$originalInvoiceNo.equals(other$originalInvoiceNo)) {
                return false;
            }
            String this$redLetterNumber = this.getRedLetterNumber();
            String other$redLetterNumber = other.getRedLetterNumber();
            if (this$redLetterNumber == null ? other$redLetterNumber != null : !this$redLetterNumber.equals(other$redLetterNumber)) {
                return false;
            }
            String this$redLetterUuid = this.getRedLetterUuid();
            String other$redLetterUuid = other.getRedLetterUuid();
            if (this$redLetterUuid == null ? other$redLetterUuid != null : !this$redLetterUuid.equals(other$redLetterUuid)) {
                return false;
            }
            String this$remark = this.getRemark();
            String other$remark = other.getRemark();
            if (this$remark == null ? other$remark != null : !this$remark.equals(other$remark)) {
                return false;
            }
            Boolean this$showBuyerBankControl = this.getShowBuyerBankControl();
            Boolean other$showBuyerBankControl = other.getShowBuyerBankControl();
            if (this$showBuyerBankControl == null ? other$showBuyerBankControl != null : !((Object)this$showBuyerBankControl).equals(other$showBuyerBankControl)) {
                return false;
            }
            Boolean this$showSellerBankControl = this.getShowSellerBankControl();
            Boolean other$showSellerBankControl = other.getShowSellerBankControl();
            if (this$showSellerBankControl == null ? other$showSellerBankControl != null : !((Object)this$showSellerBankControl).equals(other$showSellerBankControl)) {
                return false;
            }
            List<InvoiceDetail> this$invoiceDetailList = this.getInvoiceDetailList();
            List<InvoiceDetail> other$invoiceDetailList = other.getInvoiceDetailList();
            if (this$invoiceDetailList == null ? other$invoiceDetailList != null : !((Object)this$invoiceDetailList).equals(other$invoiceDetailList)) {
                return false;
            }
            List<Map<String, Object>> this$extraList = this.getExtraList();
            List<Map<String, Object>> other$extraList = other.getExtraList();
            return !(this$extraList == null ? other$extraList != null : !((Object)this$extraList).equals(other$extraList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InvoiceInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $pid = this.getPid();
            result = result * 59 + ($pid == null ? 43 : $pid.hashCode());
            String $tenantId = this.getTenantId();
            result = result * 59 + ($tenantId == null ? 43 : $tenantId.hashCode());
            String $invoiceFlag = this.getInvoiceFlag();
            result = result * 59 + ($invoiceFlag == null ? 43 : $invoiceFlag.hashCode());
            String $invoiceType = this.getInvoiceType();
            result = result * 59 + ($invoiceType == null ? 43 : $invoiceType.hashCode());
            String $invoiceStyleType = this.getInvoiceStyleType();
            result = result * 59 + ($invoiceStyleType == null ? 43 : $invoiceStyleType.hashCode());
            String $vatRefundType = this.getVatRefundType();
            result = result * 59 + ($vatRefundType == null ? 43 : $vatRefundType.hashCode());
            String $sellerTaxNo = this.getSellerTaxNo();
            result = result * 59 + ($sellerTaxNo == null ? 43 : $sellerTaxNo.hashCode());
            String $sellerName = this.getSellerName();
            result = result * 59 + ($sellerName == null ? 43 : $sellerName.hashCode());
            String $sellerAddress = this.getSellerAddress();
            result = result * 59 + ($sellerAddress == null ? 43 : $sellerAddress.hashCode());
            String $sellerTel = this.getSellerTel();
            result = result * 59 + ($sellerTel == null ? 43 : $sellerTel.hashCode());
            String $sellerBankName = this.getSellerBankName();
            result = result * 59 + ($sellerBankName == null ? 43 : $sellerBankName.hashCode());
            String $sellerBankAccount = this.getSellerBankAccount();
            result = result * 59 + ($sellerBankAccount == null ? 43 : $sellerBankAccount.hashCode());
            String $buyerTaxNo = this.getBuyerTaxNo();
            result = result * 59 + ($buyerTaxNo == null ? 43 : $buyerTaxNo.hashCode());
            String $buyerName = this.getBuyerName();
            result = result * 59 + ($buyerName == null ? 43 : $buyerName.hashCode());
            String $buyerAddress = this.getBuyerAddress();
            result = result * 59 + ($buyerAddress == null ? 43 : $buyerAddress.hashCode());
            String $buyerTel = this.getBuyerTel();
            result = result * 59 + ($buyerTel == null ? 43 : $buyerTel.hashCode());
            String $buyerBankName = this.getBuyerBankName();
            result = result * 59 + ($buyerBankName == null ? 43 : $buyerBankName.hashCode());
            String $buyerBankAccount = this.getBuyerBankAccount();
            result = result * 59 + ($buyerBankAccount == null ? 43 : $buyerBankAccount.hashCode());
            String $buyerOperatorName = this.getBuyerOperatorName();
            result = result * 59 + ($buyerOperatorName == null ? 43 : $buyerOperatorName.hashCode());
            String $buyerOperatorIdentityNo = this.getBuyerOperatorIdentityNo();
            result = result * 59 + ($buyerOperatorIdentityNo == null ? 43 : $buyerOperatorIdentityNo.hashCode());
            String $buyerOperatorTel = this.getBuyerOperatorTel();
            result = result * 59 + ($buyerOperatorTel == null ? 43 : $buyerOperatorTel.hashCode());
            Boolean $isNature = this.getIsNature();
            result = result * 59 + ($isNature == null ? 43 : ((Object)$isNature).hashCode());
            BigDecimal $amountWithoutTax = this.getAmountWithoutTax();
            result = result * 59 + ($amountWithoutTax == null ? 43 : ((Object)$amountWithoutTax).hashCode());
            BigDecimal $taxAmount = this.getTaxAmount();
            result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
            BigDecimal $amountWithTax = this.getAmountWithTax();
            result = result * 59 + ($amountWithTax == null ? 43 : ((Object)$amountWithTax).hashCode());
            String $payeeBankName = this.getPayeeBankName();
            result = result * 59 + ($payeeBankName == null ? 43 : $payeeBankName.hashCode());
            String $payeeBankAccount = this.getPayeeBankAccount();
            result = result * 59 + ($payeeBankAccount == null ? 43 : $payeeBankAccount.hashCode());
            String $settlementMode = this.getSettlementMode();
            result = result * 59 + ($settlementMode == null ? 43 : $settlementMode.hashCode());
            String $issuer = this.getIssuer();
            result = result * 59 + ($issuer == null ? 43 : $issuer.hashCode());
            String $payee = this.getPayee();
            result = result * 59 + ($payee == null ? 43 : $payee.hashCode());
            String $reviewer = this.getReviewer();
            result = result * 59 + ($reviewer == null ? 43 : $reviewer.hashCode());
            String $issuerIdentityNo = this.getIssuerIdentityNo();
            result = result * 59 + ($issuerIdentityNo == null ? 43 : $issuerIdentityNo.hashCode());
            String $issuerIdentityType = this.getIssuerIdentityType();
            result = result * 59 + ($issuerIdentityType == null ? 43 : $issuerIdentityType.hashCode());
            String $originalInvoiceNo = this.getOriginalInvoiceNo();
            result = result * 59 + ($originalInvoiceNo == null ? 43 : $originalInvoiceNo.hashCode());
            String $redLetterNumber = this.getRedLetterNumber();
            result = result * 59 + ($redLetterNumber == null ? 43 : $redLetterNumber.hashCode());
            String $redLetterUuid = this.getRedLetterUuid();
            result = result * 59 + ($redLetterUuid == null ? 43 : $redLetterUuid.hashCode());
            String $remark = this.getRemark();
            result = result * 59 + ($remark == null ? 43 : $remark.hashCode());
            Boolean $showBuyerBankControl = this.getShowBuyerBankControl();
            result = result * 59 + ($showBuyerBankControl == null ? 43 : ((Object)$showBuyerBankControl).hashCode());
            Boolean $showSellerBankControl = this.getShowSellerBankControl();
            result = result * 59 + ($showSellerBankControl == null ? 43 : ((Object)$showSellerBankControl).hashCode());
            List<InvoiceDetail> $invoiceDetailList = this.getInvoiceDetailList();
            result = result * 59 + ($invoiceDetailList == null ? 43 : ((Object)$invoiceDetailList).hashCode());
            List<Map<String, Object>> $extraList = this.getExtraList();
            result = result * 59 + ($extraList == null ? 43 : ((Object)$extraList).hashCode());
            return result;
        }

        public String toString() {
            return "MakeInvoiceMessage.InvoiceInfo(pid=" + this.getPid() + ", tenantId=" + this.getTenantId() + ", invoiceFlag=" + this.getInvoiceFlag() + ", invoiceType=" + this.getInvoiceType() + ", invoiceStyleType=" + this.getInvoiceStyleType() + ", vatRefundType=" + this.getVatRefundType() + ", sellerTaxNo=" + this.getSellerTaxNo() + ", sellerName=" + this.getSellerName() + ", sellerAddress=" + this.getSellerAddress() + ", sellerTel=" + this.getSellerTel() + ", sellerBankName=" + this.getSellerBankName() + ", sellerBankAccount=" + this.getSellerBankAccount() + ", buyerTaxNo=" + this.getBuyerTaxNo() + ", buyerName=" + this.getBuyerName() + ", buyerAddress=" + this.getBuyerAddress() + ", buyerTel=" + this.getBuyerTel() + ", buyerBankName=" + this.getBuyerBankName() + ", buyerBankAccount=" + this.getBuyerBankAccount() + ", buyerOperatorName=" + this.getBuyerOperatorName() + ", buyerOperatorIdentityNo=" + this.getBuyerOperatorIdentityNo() + ", buyerOperatorTel=" + this.getBuyerOperatorTel() + ", isNature=" + this.getIsNature() + ", amountWithoutTax=" + this.getAmountWithoutTax() + ", taxAmount=" + this.getTaxAmount() + ", amountWithTax=" + this.getAmountWithTax() + ", payeeBankName=" + this.getPayeeBankName() + ", payeeBankAccount=" + this.getPayeeBankAccount() + ", settlementMode=" + this.getSettlementMode() + ", issuer=" + this.getIssuer() + ", payee=" + this.getPayee() + ", reviewer=" + this.getReviewer() + ", issuerIdentityNo=" + this.getIssuerIdentityNo() + ", issuerIdentityType=" + this.getIssuerIdentityType() + ", originalInvoiceNo=" + this.getOriginalInvoiceNo() + ", redLetterNumber=" + this.getRedLetterNumber() + ", redLetterUuid=" + this.getRedLetterUuid() + ", remark=" + this.getRemark() + ", showBuyerBankControl=" + this.getShowBuyerBankControl() + ", showSellerBankControl=" + this.getShowSellerBankControl() + ", invoiceDetailList=" + this.getInvoiceDetailList() + ", extraList=" + this.getExtraList() + ")";
        }

        public static class Additional {
            @Length(max=200)
            private @Length(max=200) String additionalElementName;
            @Length(max=200)
            private @Length(max=200) String additionalElementType;
            @Length(max=200)
            private @Length(max=200) String additionalElementValue;

            public String getAdditionalElementName() {
                return this.additionalElementName;
            }

            public String getAdditionalElementType() {
                return this.additionalElementType;
            }

            public String getAdditionalElementValue() {
                return this.additionalElementValue;
            }

            public void setAdditionalElementName(String additionalElementName) {
                this.additionalElementName = additionalElementName;
            }

            public void setAdditionalElementType(String additionalElementType) {
                this.additionalElementType = additionalElementType;
            }

            public void setAdditionalElementValue(String additionalElementValue) {
                this.additionalElementValue = additionalElementValue;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Additional)) {
                    return false;
                }
                Additional other = (Additional)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                String this$additionalElementName = this.getAdditionalElementName();
                String other$additionalElementName = other.getAdditionalElementName();
                if (this$additionalElementName == null ? other$additionalElementName != null : !this$additionalElementName.equals(other$additionalElementName)) {
                    return false;
                }
                String this$additionalElementType = this.getAdditionalElementType();
                String other$additionalElementType = other.getAdditionalElementType();
                if (this$additionalElementType == null ? other$additionalElementType != null : !this$additionalElementType.equals(other$additionalElementType)) {
                    return false;
                }
                String this$additionalElementValue = this.getAdditionalElementValue();
                String other$additionalElementValue = other.getAdditionalElementValue();
                return !(this$additionalElementValue == null ? other$additionalElementValue != null : !this$additionalElementValue.equals(other$additionalElementValue));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Additional;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                String $additionalElementName = this.getAdditionalElementName();
                result = result * 59 + ($additionalElementName == null ? 43 : $additionalElementName.hashCode());
                String $additionalElementType = this.getAdditionalElementType();
                result = result * 59 + ($additionalElementType == null ? 43 : $additionalElementType.hashCode());
                String $additionalElementValue = this.getAdditionalElementValue();
                result = result * 59 + ($additionalElementValue == null ? 43 : $additionalElementValue.hashCode());
                return result;
            }

            public String toString() {
                return "MakeInvoiceMessage.InvoiceInfo.Additional(additionalElementName=" + this.getAdditionalElementName() + ", additionalElementType=" + this.getAdditionalElementType() + ", additionalElementValue=" + this.getAdditionalElementValue() + ")";
            }
        }

        @ScriptAssert.List(value={@ScriptAssert(lang="javascript", script="com.xforceplus.taxware.chestnut.contract.model.PostUploadAllElectricInvoiceResultMessage.InvoiceDetail.isValidUnionInfo(_this)", message="\u6570\u91cf\u3001\u5355\u4ef7\u5fc5\u987b\u540c\u65f6\u4e3a\u7a7a\u6216\u540c\u65f6\u4e0d\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5")})
        public static class InvoiceDetail {
            @NotNull
            @Digits(integer=8, fraction=0)
            private @NotNull @Digits(integer=8, fraction=0) Integer rowNum;
            @Digits(integer=8, fraction=0)
            private @Digits(integer=8, fraction=0) Integer originalRowNum;
            @NotEmpty
            @Length(max=600)
            private @NotEmpty @Length(max=600) String itemName;
            @Length(max=150)
            private @Length(max=150) String specifications;
            @Length(max=300)
            private @Length(max=300) String unit;
            @Length(max=25)
            private @Length(max=25) String quantity;
            @Length(max=25)
            private @Length(max=25) String unitPrice;
            @NotNull
            @Digits(integer=18, fraction=2)
            private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithoutTax;
            @NotNull
            @Digits(integer=16, fraction=6)
            private @NotNull @Digits(integer=16, fraction=6) BigDecimal taxRate;
            @NotNull
            @Digits(integer=18, fraction=2)
            private @NotNull @Digits(integer=18, fraction=2) BigDecimal taxAmount;
            @NotNull
            @Digits(integer=18, fraction=2)
            private @NotNull @Digits(integer=18, fraction=2) BigDecimal amountWithTax;
            @Digits(integer=18, fraction=2)
            private @Digits(integer=18, fraction=2) BigDecimal deduction;
            @NotEmpty
            @Length(max=19)
            private @NotEmpty @Length(max=19) String goodsTaxNo;
            @NotEmpty
            @Length(max=2)
            @Pattern(regexp="0[0-2]")
            private @NotEmpty @Length(max=2) @Pattern(regexp="0[0-2]") String discountType;
            @Pattern(regexp="0[1-9]|1[0-8]")
            private @Pattern(regexp="0[1-9]|1[0-8]") String taxIncentivesType;

            public Integer getRowNum() {
                return this.rowNum;
            }

            public Integer getOriginalRowNum() {
                return this.originalRowNum;
            }

            public String getItemName() {
                return this.itemName;
            }

            public String getSpecifications() {
                return this.specifications;
            }

            public String getUnit() {
                return this.unit;
            }

            public String getQuantity() {
                return this.quantity;
            }

            public String getUnitPrice() {
                return this.unitPrice;
            }

            public BigDecimal getAmountWithoutTax() {
                return this.amountWithoutTax;
            }

            public BigDecimal getTaxRate() {
                return this.taxRate;
            }

            public BigDecimal getTaxAmount() {
                return this.taxAmount;
            }

            public BigDecimal getAmountWithTax() {
                return this.amountWithTax;
            }

            public BigDecimal getDeduction() {
                return this.deduction;
            }

            public String getGoodsTaxNo() {
                return this.goodsTaxNo;
            }

            public String getDiscountType() {
                return this.discountType;
            }

            public String getTaxIncentivesType() {
                return this.taxIncentivesType;
            }

            public void setRowNum(Integer rowNum) {
                this.rowNum = rowNum;
            }

            public void setOriginalRowNum(Integer originalRowNum) {
                this.originalRowNum = originalRowNum;
            }

            public void setItemName(String itemName) {
                this.itemName = itemName;
            }

            public void setSpecifications(String specifications) {
                this.specifications = specifications;
            }

            public void setUnit(String unit) {
                this.unit = unit;
            }

            public void setQuantity(String quantity) {
                this.quantity = quantity;
            }

            public void setUnitPrice(String unitPrice) {
                this.unitPrice = unitPrice;
            }

            public void setAmountWithoutTax(BigDecimal amountWithoutTax) {
                this.amountWithoutTax = amountWithoutTax;
            }

            public void setTaxRate(BigDecimal taxRate) {
                this.taxRate = taxRate;
            }

            public void setTaxAmount(BigDecimal taxAmount) {
                this.taxAmount = taxAmount;
            }

            public void setAmountWithTax(BigDecimal amountWithTax) {
                this.amountWithTax = amountWithTax;
            }

            public void setDeduction(BigDecimal deduction) {
                this.deduction = deduction;
            }

            public void setGoodsTaxNo(String goodsTaxNo) {
                this.goodsTaxNo = goodsTaxNo;
            }

            public void setDiscountType(String discountType) {
                this.discountType = discountType;
            }

            public void setTaxIncentivesType(String taxIncentivesType) {
                this.taxIncentivesType = taxIncentivesType;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof InvoiceDetail)) {
                    return false;
                }
                InvoiceDetail other = (InvoiceDetail)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Integer this$rowNum = this.getRowNum();
                Integer other$rowNum = other.getRowNum();
                if (this$rowNum == null ? other$rowNum != null : !((Object)this$rowNum).equals(other$rowNum)) {
                    return false;
                }
                Integer this$originalRowNum = this.getOriginalRowNum();
                Integer other$originalRowNum = other.getOriginalRowNum();
                if (this$originalRowNum == null ? other$originalRowNum != null : !((Object)this$originalRowNum).equals(other$originalRowNum)) {
                    return false;
                }
                String this$itemName = this.getItemName();
                String other$itemName = other.getItemName();
                if (this$itemName == null ? other$itemName != null : !this$itemName.equals(other$itemName)) {
                    return false;
                }
                String this$specifications = this.getSpecifications();
                String other$specifications = other.getSpecifications();
                if (this$specifications == null ? other$specifications != null : !this$specifications.equals(other$specifications)) {
                    return false;
                }
                String this$unit = this.getUnit();
                String other$unit = other.getUnit();
                if (this$unit == null ? other$unit != null : !this$unit.equals(other$unit)) {
                    return false;
                }
                String this$quantity = this.getQuantity();
                String other$quantity = other.getQuantity();
                if (this$quantity == null ? other$quantity != null : !this$quantity.equals(other$quantity)) {
                    return false;
                }
                String this$unitPrice = this.getUnitPrice();
                String other$unitPrice = other.getUnitPrice();
                if (this$unitPrice == null ? other$unitPrice != null : !this$unitPrice.equals(other$unitPrice)) {
                    return false;
                }
                BigDecimal this$amountWithoutTax = this.getAmountWithoutTax();
                BigDecimal other$amountWithoutTax = other.getAmountWithoutTax();
                if (this$amountWithoutTax == null ? other$amountWithoutTax != null : !((Object)this$amountWithoutTax).equals(other$amountWithoutTax)) {
                    return false;
                }
                BigDecimal this$taxRate = this.getTaxRate();
                BigDecimal other$taxRate = other.getTaxRate();
                if (this$taxRate == null ? other$taxRate != null : !((Object)this$taxRate).equals(other$taxRate)) {
                    return false;
                }
                BigDecimal this$taxAmount = this.getTaxAmount();
                BigDecimal other$taxAmount = other.getTaxAmount();
                if (this$taxAmount == null ? other$taxAmount != null : !((Object)this$taxAmount).equals(other$taxAmount)) {
                    return false;
                }
                BigDecimal this$amountWithTax = this.getAmountWithTax();
                BigDecimal other$amountWithTax = other.getAmountWithTax();
                if (this$amountWithTax == null ? other$amountWithTax != null : !((Object)this$amountWithTax).equals(other$amountWithTax)) {
                    return false;
                }
                BigDecimal this$deduction = this.getDeduction();
                BigDecimal other$deduction = other.getDeduction();
                if (this$deduction == null ? other$deduction != null : !((Object)this$deduction).equals(other$deduction)) {
                    return false;
                }
                String this$goodsTaxNo = this.getGoodsTaxNo();
                String other$goodsTaxNo = other.getGoodsTaxNo();
                if (this$goodsTaxNo == null ? other$goodsTaxNo != null : !this$goodsTaxNo.equals(other$goodsTaxNo)) {
                    return false;
                }
                String this$discountType = this.getDiscountType();
                String other$discountType = other.getDiscountType();
                if (this$discountType == null ? other$discountType != null : !this$discountType.equals(other$discountType)) {
                    return false;
                }
                String this$taxIncentivesType = this.getTaxIncentivesType();
                String other$taxIncentivesType = other.getTaxIncentivesType();
                return !(this$taxIncentivesType == null ? other$taxIncentivesType != null : !this$taxIncentivesType.equals(other$taxIncentivesType));
            }

            protected boolean canEqual(Object other) {
                return other instanceof InvoiceDetail;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Integer $rowNum = this.getRowNum();
                result = result * 59 + ($rowNum == null ? 43 : ((Object)$rowNum).hashCode());
                Integer $originalRowNum = this.getOriginalRowNum();
                result = result * 59 + ($originalRowNum == null ? 43 : ((Object)$originalRowNum).hashCode());
                String $itemName = this.getItemName();
                result = result * 59 + ($itemName == null ? 43 : $itemName.hashCode());
                String $specifications = this.getSpecifications();
                result = result * 59 + ($specifications == null ? 43 : $specifications.hashCode());
                String $unit = this.getUnit();
                result = result * 59 + ($unit == null ? 43 : $unit.hashCode());
                String $quantity = this.getQuantity();
                result = result * 59 + ($quantity == null ? 43 : $quantity.hashCode());
                String $unitPrice = this.getUnitPrice();
                result = result * 59 + ($unitPrice == null ? 43 : $unitPrice.hashCode());
                BigDecimal $amountWithoutTax = this.getAmountWithoutTax();
                result = result * 59 + ($amountWithoutTax == null ? 43 : ((Object)$amountWithoutTax).hashCode());
                BigDecimal $taxRate = this.getTaxRate();
                result = result * 59 + ($taxRate == null ? 43 : ((Object)$taxRate).hashCode());
                BigDecimal $taxAmount = this.getTaxAmount();
                result = result * 59 + ($taxAmount == null ? 43 : ((Object)$taxAmount).hashCode());
                BigDecimal $amountWithTax = this.getAmountWithTax();
                result = result * 59 + ($amountWithTax == null ? 43 : ((Object)$amountWithTax).hashCode());
                BigDecimal $deduction = this.getDeduction();
                result = result * 59 + ($deduction == null ? 43 : ((Object)$deduction).hashCode());
                String $goodsTaxNo = this.getGoodsTaxNo();
                result = result * 59 + ($goodsTaxNo == null ? 43 : $goodsTaxNo.hashCode());
                String $discountType = this.getDiscountType();
                result = result * 59 + ($discountType == null ? 43 : $discountType.hashCode());
                String $taxIncentivesType = this.getTaxIncentivesType();
                result = result * 59 + ($taxIncentivesType == null ? 43 : $taxIncentivesType.hashCode());
                return result;
            }

            public String toString() {
                return "MakeInvoiceMessage.InvoiceInfo.InvoiceDetail(rowNum=" + this.getRowNum() + ", originalRowNum=" + this.getOriginalRowNum() + ", itemName=" + this.getItemName() + ", specifications=" + this.getSpecifications() + ", unit=" + this.getUnit() + ", quantity=" + this.getQuantity() + ", unitPrice=" + this.getUnitPrice() + ", amountWithoutTax=" + this.getAmountWithoutTax() + ", taxRate=" + this.getTaxRate() + ", taxAmount=" + this.getTaxAmount() + ", amountWithTax=" + this.getAmountWithTax() + ", deduction=" + this.getDeduction() + ", goodsTaxNo=" + this.getGoodsTaxNo() + ", discountType=" + this.getDiscountType() + ", taxIncentivesType=" + this.getTaxIncentivesType() + ")";
            }
        }
    }

    public static class Request {
        @NotEmpty
        private String taskId;
        private List<InvoiceInfo> invoiceInfos;

        public String getTaskId() {
            return this.taskId;
        }

        public List<InvoiceInfo> getInvoiceInfos() {
            return this.invoiceInfos;
        }

        public void setTaskId(String taskId) {
            this.taskId = taskId;
        }

        public void setInvoiceInfos(List<InvoiceInfo> invoiceInfos) {
            this.invoiceInfos = invoiceInfos;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Request)) {
                return false;
            }
            Request other = (Request)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$taskId = this.getTaskId();
            String other$taskId = other.getTaskId();
            if (this$taskId == null ? other$taskId != null : !this$taskId.equals(other$taskId)) {
                return false;
            }
            List<InvoiceInfo> this$invoiceInfos = this.getInvoiceInfos();
            List<InvoiceInfo> other$invoiceInfos = other.getInvoiceInfos();
            return !(this$invoiceInfos == null ? other$invoiceInfos != null : !((Object)this$invoiceInfos).equals(other$invoiceInfos));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Request;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $taskId = this.getTaskId();
            result = result * 59 + ($taskId == null ? 43 : $taskId.hashCode());
            List<InvoiceInfo> $invoiceInfos = this.getInvoiceInfos();
            result = result * 59 + ($invoiceInfos == null ? 43 : ((Object)$invoiceInfos).hashCode());
            return result;
        }

        public String toString() {
            return "MakeInvoiceMessage.Request(taskId=" + this.getTaskId() + ", invoiceInfos=" + this.getInvoiceInfos() + ")";
        }
    }
}

