/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.chestnut.contract.model.constant.enums;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public enum CapabilityCodeEnum {
    COMMON("00", 1, "202007", "911001", "\u4e50\u4f01\u5f00\u7968\u80fd\u529b\uff08\u57fa\u7840\u7248\uff09"),
    OIL("01", 2, "202055", "999888", "\u4e50\u4f01\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u6210\u54c1\u6cb9\uff09\u5f00\u7968\u80fd\u529b"),
    CONSTRUCTION_SERVICE("03", 4, "202044", "202206", "\u4e50\u4f01\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u5efa\u7b51\u670d\u52a1\uff09\u5f00\u7968\u80fd\u529b"),
    FREIGHT_SERVICE("04", 8, "202026", "230207004", "\u4e50\u4f01\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u8d27\u7269\u8fd0\u8f93\u670d\u52a1\uff09\u5f00\u7968\u80fd\u529b"),
    REAL_ESTATE_SALES("05", 16, "202046", "202204", "\u4e50\u4f01\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u4e0d\u52a8\u4ea7\u9500\u552e\uff09\u5f00\u7968\u80fd\u529b"),
    REAL_ESTATE_LEASE("06", 32, "202038", "202036", "\u4e50\u4f01\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u4e0d\u52a8\u4ea7\u7ecf\u8425\u79df\u8d41\uff09\u5f00\u7968\u80fd\u529b"),
    PASSENGER_TRANSPORTATION("09", 64, "202027", "230207003", "\u4e50\u4f01\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u65c5\u5ba2\u8fd0\u8f93\u670d\u52a1\uff09\u5f00\u7968\u80fd\u529b"),
    PRODUCE_SALES("12", 128, "202031", "1234567", "\u4e50\u4f01\u6570\u5b57\u5316\u7535\u5b50\u53d1\u7968\uff08\u519c\u4ea7\u54c1\u9500\u552e\uff09\u5f00\u7968\u80fd\u529b"),
    PRODUCE_PURCHASE("16", 256, "202019", "202019", "\u4e50\u4f01\u5168\u7535\u53d1\u7968\uff08\u519c\u4ea7\u54c1\u6536\u8d2d\uff09\u5f00\u7968\u80fd\u529b"),
    PHOTOVOLTAIC_ACQUISITION("17", 512, "202017", "202017", "\u4e50\u4f01\u5168\u7535\u53d1\u7968\uff08\u5149\u4f0f\u6536\u8d2d\uff09\u5f00\u7968\u80fd\u529b"),
    COLLECTION("99", 1024, "203067", "203067", "\u4e50\u4f01\u5f52\u96c6\u80fd\u529b"),
    DEDUCTION("100", 2048, "203065", "203065", "\u4e50\u4f01\u589e\u503c\u7a0e\u62b5\u6263\u52fe\u9009\u80fd\u529b"),
    TAX_REFUND_DEDUCTION("101", 4096, "203064", "203064", "\u4e50\u4f01\u589e\u503c\u7a0e\u9000\u7a0e\u52fe\u9009\u80fd\u529b"),
    DEPUTY_TAX_REFUND_DEDUCTION("102", 8192, "203066", "203066", "\u4e50\u4f01\u4ee3\u529e\u9000\u7a0e\u52fe\u9009\u80fd\u529b"),
    ENTRY("103", 16384, "203057", "203057", "\u53d1\u7968\u5165\u8d26\u80fd\u529b"),
    VERIFICATION("104", 32768, "203059", "203059", "\u4e50\u4f01\u53d1\u7968\u67e5\u9a8c\u80fd\u529b"),
    COMBINED_COMMON("200", 65536, "202076", "102302", "\u4e50\u4f01\u8054\u7528\u6570\u7535\u53d1\u7968\uff08\u57fa\u7840\u7248\uff09\u5f00\u7968\u80fd\u529b"),
    OTHER_COMMON("300", 131072, "202077", "102301", "\u4e50\u4f01\u4ed6\u7528\u6570\u7535\u53d1\u7968\uff08\u57fa\u7840\u7248\uff09\u5f00\u7968\u80fd\u529b"),
    UNIT_MANAGEMENT("105", 262144, "100010", "", "\u4f7f\u7528\u5355\u4f4d\u7ba1\u7406\u80fd\u529b"),
    COMPLIANCE("106", 524288, "100011", "", "\u4e50\u4f01\u5b9e\u8d28\u5408\u89c4\u670d\u52a1\u80fd\u529b"),
    RED_ALERT("107", 0x100000, "100012", "", "\u7ea2\u8272\u9884\u8b66\u68c0\u6d4b\u80fd\u529b"),
    JEWELRY_26("26", 0x200000, "202084", "202084", "\u4e50\u4f01\u6570\u7535\u53d1\u7968\uff08\u91d1\u94f6\u9996\u9970\uff09\u5f00\u7968\u80fd\u529b"),
    JEWELRY_27("27", 0x400000, "202084", "202084", "\u4e50\u4f01\u6570\u7535\u53d1\u7968\uff08\u91d1\u94f6\u9996\u9970\uff09\u5f00\u7968\u80fd\u529b");

    private final String code;
    private final int numCode;
    private final String capabilityCode;
    private final String caseCode;
    private final String desc;

    private CapabilityCodeEnum(String code, int numCode, String capabilityCode, String caseCode, String desc) {
        this.code = code;
        this.numCode = numCode;
        this.capabilityCode = capabilityCode;
        this.caseCode = caseCode;
        this.desc = desc;
    }

    public String toCode() {
        return this.code;
    }

    public int toNumCode() {
        return this.numCode;
    }

    public String toCapabilityCode() {
        return this.capabilityCode;
    }

    public String toDesc() {
        return this.desc;
    }

    public String toCaseCode() {
        return this.caseCode;
    }

    public static CapabilityCodeEnum fromCode(String code) {
        return Arrays.stream(CapabilityCodeEnum.values()).filter(x -> Objects.equals(x.code, code)).findAny().orElse(COMMON);
    }

    public static CapabilityCodeEnum fromCapabilityCode(String capabilityCode) {
        return Arrays.stream(CapabilityCodeEnum.values()).filter(x -> Objects.equals(x.capabilityCode, capabilityCode)).findAny().orElse(COMMON);
    }

    public static CapabilityCodeEnum fromCapabilityCodeNoDefault(String capabilityCode) {
        return Arrays.stream(CapabilityCodeEnum.values()).filter(x -> Objects.equals(x.capabilityCode, capabilityCode)).findAny().orElse(null);
    }

    public static List<CapabilityCodeEnum> fromCodeList(List<String> codeList) {
        if (codeList == null) {
            return List.of(COMMON);
        }
        return codeList.stream().map(CapabilityCodeEnum::fromCode).collect(Collectors.toList());
    }

    public static List<CapabilityCodeEnum> fromCodeList(String[] codeList) {
        if (codeList == null) {
            return List.of(COMMON);
        }
        return Arrays.stream(codeList).map(CapabilityCodeEnum::fromCapabilityCode).collect(Collectors.toList());
    }

    public static List<CapabilityCodeEnum> fromCodeList(String[] codeList, boolean noDefault) {
        return Arrays.stream(codeList).map(CapabilityCodeEnum::fromCapabilityCodeNoDefault).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static List<CapabilityCodeEnum> fromNumCode(Integer numCode) {
        if (numCode == null || numCode == 0) {
            return List.of(COMMON);
        }
        return Arrays.stream(CapabilityCodeEnum.values()).filter(x -> (x.numCode & numCode) > 0).collect(Collectors.toList());
    }

    public static int to(List<CapabilityCodeEnum> capabilityCodeEnums) {
        int numCode = 0;
        if (capabilityCodeEnums == null) {
            return CapabilityCodeEnum.COMMON.numCode;
        }
        for (CapabilityCodeEnum capabilityCodeEnum : capabilityCodeEnums) {
            numCode += capabilityCodeEnum.numCode;
        }
        return numCode;
    }

    public static List<String> toCodeList(List<CapabilityCodeEnum> capabilityCodeEnums) {
        if (capabilityCodeEnums == null) {
            return Collections.singletonList(CapabilityCodeEnum.COMMON.code);
        }
        return capabilityCodeEnums.stream().map(CapabilityCodeEnum::toCode).collect(Collectors.toList());
    }
}

