/*
 * Decompiled with CFR 0.152.
 */
package com.xforceplus.taxware.microservice.outputinvoice.contract.openapi.model;

public class PageDto {
    private int currentPage;
    private int pageSize;
    private int totalNum;
    private int first = 1;
    private int last;
    private int totalPage;
    private int prev;
    private int next;
    private int startNum;
    private int start;
    private int end;
    private int count = 10;

    public PageDto() {
    }

    public PageDto(int currentPage, int pageSize, int totalNum) {
        this.currentPage = currentPage;
        this.pageSize = pageSize;
        this.totalNum = totalNum;
        this.totalPage = this.last = (int)Math.ceil((double)totalNum / (double)pageSize);
        this.currentPage = Math.max(this.currentPage, 1);
        this.currentPage = Math.min(this.totalPage, this.currentPage);
        this.prev = Math.max(this.currentPage - 1, 1);
        this.next = Math.min(this.currentPage + 1, this.totalPage);
        this.startNum = (this.currentPage - 1) * pageSize;
        this.start = Math.max(this.currentPage - this.count / 2, 1);
        this.end = Math.min(this.start + this.count, this.totalPage);
    }

    public int getCurrentPage() {
        return this.currentPage;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public int getTotalNum() {
        return this.totalNum;
    }

    public int getFirst() {
        return this.first;
    }

    public int getLast() {
        return this.last;
    }

    public int getTotalPage() {
        return this.totalPage;
    }

    public int getPrev() {
        return this.prev;
    }

    public int getNext() {
        return this.next;
    }

    public int getStartNum() {
        return this.startNum;
    }

    public int getStart() {
        return this.start;
    }

    public int getEnd() {
        return this.end;
    }

    public int getCount() {
        return this.count;
    }

    public void setCurrentPage(int currentPage) {
        this.currentPage = currentPage;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotalNum(int totalNum) {
        this.totalNum = totalNum;
    }

    public void setFirst(int first) {
        this.first = first;
    }

    public void setLast(int last) {
        this.last = last;
    }

    public void setTotalPage(int totalPage) {
        this.totalPage = totalPage;
    }

    public void setPrev(int prev) {
        this.prev = prev;
    }

    public void setNext(int next) {
        this.next = next;
    }

    public void setStartNum(int startNum) {
        this.startNum = startNum;
    }

    public void setStart(int start) {
        this.start = start;
    }

    public void setEnd(int end) {
        this.end = end;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageDto)) {
            return false;
        }
        PageDto other = (PageDto)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCurrentPage() != other.getCurrentPage()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotalNum() != other.getTotalNum()) {
            return false;
        }
        if (this.getFirst() != other.getFirst()) {
            return false;
        }
        if (this.getLast() != other.getLast()) {
            return false;
        }
        if (this.getTotalPage() != other.getTotalPage()) {
            return false;
        }
        if (this.getPrev() != other.getPrev()) {
            return false;
        }
        if (this.getNext() != other.getNext()) {
            return false;
        }
        if (this.getStartNum() != other.getStartNum()) {
            return false;
        }
        if (this.getStart() != other.getStart()) {
            return false;
        }
        if (this.getEnd() != other.getEnd()) {
            return false;
        }
        return this.getCount() == other.getCount();
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageDto;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCurrentPage();
        result = result * 59 + this.getPageSize();
        result = result * 59 + this.getTotalNum();
        result = result * 59 + this.getFirst();
        result = result * 59 + this.getLast();
        result = result * 59 + this.getTotalPage();
        result = result * 59 + this.getPrev();
        result = result * 59 + this.getNext();
        result = result * 59 + this.getStartNum();
        result = result * 59 + this.getStart();
        result = result * 59 + this.getEnd();
        result = result * 59 + this.getCount();
        return result;
    }

    public String toString() {
        return "PageDto(currentPage=" + this.getCurrentPage() + ", pageSize=" + this.getPageSize() + ", totalNum=" + this.getTotalNum() + ", first=" + this.getFirst() + ", last=" + this.getLast() + ", totalPage=" + this.getTotalPage() + ", prev=" + this.getPrev() + ", next=" + this.getNext() + ", startNum=" + this.getStartNum() + ", start=" + this.getStart() + ", end=" + this.getEnd() + ", count=" + this.getCount() + ")";
    }
}

