package com.xforceplus.taxware.microservice.bananaservice.contract.model;

import lombok.Data;

import java.util.List;

/**
 * 网上抄报清卡上抛契约
 *
 * @author Bobo
 * @create 2021/11/16 10:26
 * @since 1.0.0
 */
public class TaxationDeclareUploadMessage {

    @Data
    public static class Request {

        /**
         * 操作类型
         * query：更新最新状态
         * onlineTaxReturn：网上汇总抄报
         * cleanCard：清卡
         */
        private String operationType;

        /**
         * 设备编号列表
         */
        private List<String> deviceNoList;

    }

    @Data
    public static class Response extends BaseResponseDto {

        /**
         * 税号
         */
        private String taxCode;

        /**
         * 设备编号
         */
        private String deviceNo;

        /**
         * 事件发生时间 格式：yyyy-MM-dd HH:mm:ss.SSS
         */
        private String eventTime;

        /**
         * 网上汇总抄报结果
         */
        private List<TaxationInfoResult> taxationInfoResultList;

        /**
         * 清卡结果
         */
        private List<CleanCardInfoResult> cleanCardInfoResultList;

        /**
         * 网上汇总抄报结果
         */
        @Data
        public static class TaxationInfoResult {
            private String code = "TXWR000000";
            private String message = "成功";

            /**
             * 发票类型
             */
            private String invoiceType;

            /**
             * 最新报税日期 格式：yyyy-MM-dd
             */
            private String latestDeclarationDate;

        }

        /**
         * 清卡结果结果
         */
        @Data
        public static class CleanCardInfoResult {
            private String code = "TXWR000000";
            private String message = "成功";

            /**
             * 发票类型
             */
            private String invoiceType;

            /**
             * 开票截止时间 格式：yyyy-MM-dd
             */
            private String lockDate;

        }
    }
}
