package com.xforceplus.taxware.microservice.bananaservice.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

public class QueryDeviceSettingMessage {

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {

        private Result result;

        @Data
        public static class Result {

            private List<DeviceDto> deviceList;

            /**
             * 数据总量
             */
            private Integer totalCount;

            /**
             * 每页数据大小
             */
            private Integer pageSize;

            /**
             * 当前页
             */
            private Integer pageNo;

            @Data
            public static class DeviceDto {

                /**
                 * MI账号
                 */
                private String miAccount;

                /**
                 * 在线开始日期（格式：yyyyMMddHHmmss）
                 */
                private String onlineStartDate;

                /**
                 * 在线结束日期（格式：yyyyMMddHHmmss）
                 */
                private String onlineEndDate;

                /**
                 * 在线开始时间（格式：HHmmss）
                 */
                private String onlineStartTime;

                /**
                 * 在线结束时间（格式：HHmmss）
                 */
                private String onlineEndTime;

                /**
                 * 容忍度(公差)，单位：秒
                 */
                private Integer tolerance;

                /**
                 * 租户代码
                 */
                private String tenantCode;

                /**
                 * 公司税号
                 */
                private String companyTaxCode;

                /**
                 * 开票机号
                 */
                private String invoicingMachineNo;

                /**
                 * 开票时长
                 */
                private Integer invoiceEstimatedTime;

                /**
                 * 物理机名称
                 */
                private String parentHostname;

                /**
                 * 物理机IP
                 */
                private String parentHostIp;

                /**
                 * 公司名
                 */
                private String companyName;

                /**
                 * 机器码
                 */
                private String deviceNo;

                /**
                 * 列坐标
                 */
                private String columnCoordinate;

                /**
                 * 行坐标
                 */
                private String rowCoordinate;

                /**
                 * 税盘状态标识 (1:已启用2:待上架3:盘未查收4:下架5:永久下架6:未启用)
                 */
                private Integer deviceStatus;

                /**
                 * 库存阈值
                 */
                private Integer stockThreshold;

                /**
                 * 负载模式 balance-负载均衡 greenchannel-绿色通道
                 */
                private String loadMode;

                /**
                 * 汇总月份
                 */
                private String summaryMonth;

                /**
                 * 税盘类型
                 * 1:百旺税控盘
                 * 2:航信金税盘
                 * 4:税务UKey
                 * 7:百望核心板
                 */
                private String vendorType;

                /**
                 * 历峰专用编码 bp
                 */
                private String bp;

                /**
                 * 账号体系
                 */
                private String accountType;

                /**
                 * 抄报信息
                 */
                private List<TaxationInfo> taxationInfoList;

                /**
                 * 清卡信息
                 */
                private List<CleanCardInfo> cleanCardInfoList;

                /**
                 * 在线标识
                 * 1：已启用
                 * 2：待上架
                 * 3：盘未查收
                 * 4：下架
                 * 6：未启用
                 */
                private String onlineFlag;

                @Data
                public static class TaxationInfo {

                    /**
                     * 最新报税时间
                     */
                    private String latestDeclarationDate;

                    /**
                     * 票种
                     */
                    private String invoiceType;
                }

                @Data
                public static class CleanCardInfo {

                    /**
                     * 锁死日期
                     */
                    private String lockDate;

                    /**
                     * 票种
                     */
                    private String invoiceType;
                }
            }
        }
    }
}
