package com.xforceplus.taxware.microservice.bananaservice.contract.model;

import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.ArrayList;
import java.util.List;

public class QueryTaxCtrlServerMessage {

    @Data
    @EqualsAndHashCode(callSuper = true)
    public static class Response extends BaseResponseDto {

        private Result result = new Result();

        @Data
        public static class Result {

            /**
             * 机器列表
             */
            private List<TaxCtrlServer> machineList = new ArrayList<>();

            /**
             * linux机器
             */
            @Data
            public static class TaxCtrlServer {

                /**
                 * 物理机名字
                 */
                private String computerName;

                /**
                 * 物理机IP
                 */
                private String ip;

                /**
                 * 机柜编码
                 */
                private String rackCode;

                /**
                 * 税盘类型
                 */
                private String taxDiskType;

                /**
                 * U位
                 */
                private String uLocation;

                /**
                 * 远程方式
                 */
                private String remoteMode;

                /**
                 * 防火墙IP
                 */
                private String firewallIp;

                /**
                 * 防火墙带宽
                 */
                private String firewallBandwidth;

                /**
                 * 购买时间
                 */
                private Long purchaseDate;

                /**
                 * hub是否支持通断
                 */
                private Boolean hubSupportRestart;

                /**
                 * 是否自动恢复USB
                 */
                private Boolean autoRecoverUsb;

                /**
                 * 开票通道
                 */
                private String invoicingChannel;

                /**
                 * 调用地址
                 */
                private String baseUrl;

                /**
                 * mac地址
                 */
                private String macAddress;

                /**
                 * P4服务器终端编号
                 */
                private String p4TerminalNo;

                /**
                 * 是否渠道服务器
                 */
                private Boolean isProviderServer;

                public Boolean isProviderServer() {
                    if (this.computerName == null || "".equals(this.computerName) || !this.computerName.startsWith("P")) {
                        return false;
                    }

                    return this.getInvoicingChannel() != null;
                }
            }
        }
    }
}
