package com.xforceplus.taxware.microservice.bananaservice.contract.model;

import com.google.api.client.util.Lists;
import com.xforceplus.taxware.architecture.g1.domain.contract.BaseRestfulResponseDTO;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Thj
 * @createdAt: 2022/3/23 9:48 上午
 * @Description:
 */
public class TaxationDeclareResult {

    @Data
    public static class Request {
        private String deviceNo;
        private String taxCode;
        private List<CleanCardResult> cleanCardResultList = Lists.newArrayList();
        private List<CopyTaxationResult> taxationResultList = Lists.newArrayList();

        @Data
        public static class CopyTaxationResult {
            private String invoiceType;
            private String latestDeclarationDate;
        }

        @Data
        public static class CleanCardResult {
            private String invoiceType;
            private String lockDate;
        }
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseRestfulResponseDTO {
        private String copyTaxationMessage;
        private String cleanCardMessage;
    }
}
