package com.xforceplus.taxware.microservice.bananaservice.contract.model;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author Thj
 * @createdAt: 2022/4/24 5:54 下午
 * @Description: 签名确认结果导入契约
 */
public class EnsureResultImportMessage {

    @Data
    public static class Request {

        @JSONField(name = "APIKey")
        private final String aPIKey = "APIKey";

        private final String method = "xforceplus.company.invoice.import";

        private String userId;
        private String password;
        private String companyTaxNo;
        private String taxPeriod;
        private List<Invoice> invoice;

        @Data
        public static class Invoice {
            private String id;
            private String isCheck;
            private String invoiceOrig;
            private String znxNo;
            private String qdInvoiceNo;
            private String invoiceCode;
            private String invoiceNo;
            private String paperDrewDate;
            private String sellerTaxNo;
            private String sellerName;
            private String amountWithoutTax;
            private String taxAmount;
            private String effectiveTaxAmount;
            private String invType;
            private String invoiceType;
            private String status;
            private String checkTime;
            private String fxdj;
        }
    }

    @EqualsAndHashCode(callSuper = true)
    @Data
    public static class Response extends BaseResponseDto {
        private String result;
    }
}
