/*
 * Decompiled with CFR 0.152.
 */
package z1.pdf.verify.controller;

import java.security.GeneralSecurityException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import z1.pdf.verify.exception.VerifyTerminateException;
import z1.pdf.verify.pojo.vo.ErrorResp;

@ControllerAdvice
public class ExceptionController {
    private static final Logger log = LoggerFactory.getLogger(ExceptionController.class);

    @ExceptionHandler(value={RuntimeException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    public ErrorResp userExceptionHandler(Exception e, HttpServletRequest request) {
        ErrorResp resp = new ErrorResp();
        resp.setTimestamp(System.currentTimeMillis());
        resp.setStatus(HttpStatus.BAD_REQUEST.value());
        resp.setError(HttpStatus.BAD_REQUEST.getReasonPhrase());
        resp.setMessage(e.getMessage());
        resp.setPath(request.getRequestURI());
        return resp;
    }

    @ExceptionHandler(value={Exception.class, GeneralSecurityException.class, VerifyTerminateException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.INTERNAL_SERVER_ERROR)
    public ErrorResp exceptionHandler(Exception e, HttpServletRequest request) {
        ErrorResp resp = new ErrorResp();
        resp.setTimestamp(System.currentTimeMillis());
        resp.setStatus(HttpStatus.INTERNAL_SERVER_ERROR.value());
        resp.setError(HttpStatus.INTERNAL_SERVER_ERROR.getReasonPhrase());
        resp.setMessage(e.getMessage());
        resp.setPath(request.getRequestURI());
        log.error("", (Throwable)e);
        return resp;
    }
}

