/*
 * Decompiled with CFR 0.152.
 */
package z1.pdf.verify.controller;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestPart;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import z1.pdf.verify.pojo.bo.SignVerifyResp;
import z1.pdf.verify.pojo.vo.CommonResp;
import z1.pdf.verify.pojo.vo.SignVerifyResultResp;
import z1.pdf.verify.service.PdfService;
import z1.pdf.verify.util.enums.UserCode;

@RestController
public class PdfController {
    @Autowired
    private PdfService pdfService;

    @PostMapping(value={"/pdfs"})
    @ResponseStatus(value=HttpStatus.OK)
    @ResponseBody
    public CommonResp uploadPdf(@RequestPart MultipartFile file) throws Exception {
        Assert.notNull((Object)file, (String)"\u4e0a\u4f20\u7684\u6587\u4ef6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)file.getOriginalFilename().endsWith("pdf"), (String)"\u6587\u4ef6\u5fc5\u987b\u662fPDF\u683c\u5f0f");
        SignVerifyResultResp resp = new SignVerifyResultResp(UserCode.SUCCESS);
        List<SignVerifyResp> list = this.pdfService.checkPdfSignature(file.getBytes());
        resp.setData(list);
        if (list.isEmpty()) {
            resp.setPdfId(null);
        }
        return resp;
    }
}

