/*
 * Decompiled with CFR 0.152.
 */
package z1.pdf.verify.service.impl;

import com.itextpdf.text.pdf.AcroFields;
import com.itextpdf.text.pdf.PdfReader;
import com.itextpdf.text.pdf.security.PdfPKCS7;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateFactory;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509CRL;
import java.security.cert.X509CRLEntry;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import java.util.List;
import java.util.concurrent.TimeUnit;
import javax.naming.AuthenticationException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DLSequence;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import z1.pdf.verify.exception.VerifyTerminateException;
import z1.pdf.verify.pojo.bo.SignVerifyResp;
import z1.pdf.verify.pojo.vo.RevocationInfo;
import z1.pdf.verify.service.PdfService;

@Service
public class PdfServiceImpl
implements PdfService {
    private static final Logger log = LoggerFactory.getLogger(PdfServiceImpl.class);
    private static final String PDF_FILE_SUFFIX = ".pdf";
    static final TrustManager[] trustAllCerts;

    @Override
    public List<SignVerifyResp> checkPdfSignature(byte[] bytes) throws Exception {
        PdfReader reader = new PdfReader(bytes);
        AcroFields acroFields = reader.getAcroFields();
        ArrayList signNames = acroFields.getSignatureNames();
        if (signNames.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<SignVerifyResp> list = new ArrayList<SignVerifyResp>();
        for (String name : signNames) {
            SignVerifyResp resp = new SignVerifyResp();
            PdfPKCS7 sign = acroFields.verifySignature(name);
            resp.setSignatureName(name);
            resp.setIsSignatureCoversWholeDocument(acroFields.signatureCoversWholeDocument(name));
            resp.setSignDate(sign.getSignDate().getTime().getTime());
            resp.setCertificateUser(sign.getSigningCertificate().getSubjectDN().toString());
            resp.setCertificateIssuer(sign.getSigningCertificate().getIssuerDN().toString());
            resp.setCertificateStartDate(sign.getSigningCertificate().getNotBefore().getTime());
            resp.setCertificateCancelDate(sign.getSigningCertificate().getNotAfter().getTime());
            if (!acroFields.signatureCoversWholeDocument(name)) {
                throw new VerifyTerminateException("\u7b7e\u540d\u672a\u8986\u76d6\u6587\u6863\u6240\u6709\u5185\u5bb9,\u53ef\u80fd\u88ab\u7be1\u6539");
            }
            if (sign.getSignDate().getTime().getTime() < sign.getSigningCertificate().getNotBefore().getTime()) {
                throw new VerifyTerminateException("\u7b7e\u7ae0\u65f6\u95f4\u65e9\u4e8e\u7b7e\u7ae0\u8bc1\u4e66\u6709\u6548\u8d77\u59cb\u65f6\u95f4");
            }
            if (sign.getSignDate().getTime().getTime() > sign.getSigningCertificate().getNotAfter().getTime()) {
                throw new VerifyTerminateException("\u7b7e\u7ae0\u65f6\u95f4\u8d85\u8fc7\u7b7e\u7ae0\u8bc1\u4e66\u6709\u6548\u622a\u6b62\u65f6\u95f4");
            }
            if (!sign.verify()) {
                throw new VerifyTerminateException("\u7b7e\u540d\u9a8c\u8bc1\u65e0\u6548");
            }
            resp.setIsSignatureAvailable(sign.verify());
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate rootCa = (X509Certificate)cf.generateCertificate(new FileInputStream("src/main/resources/cert/szca.cer"));
            for (Certificate certificate : sign.getCertificates()) {
                PdfServiceImpl.doVerifyAndReturnRevocationIfno((X509Certificate)certificate, rootCa);
            }
            try {
                sign.getSigningCertificate().checkValidity();
            }
            catch (CertificateExpiredException e) {
                resp.setIsCertificateExpired(true);
            }
            catch (CertificateNotYetValidException e) {
                resp.setIsCertificateExpired(false);
            }
            boolean hasTimeStampToken = sign.getTimeStampToken() != null;
            resp.setTimeStampEmbedded(hasTimeStampToken);
            if (hasTimeStampToken) {
                resp.setTimestampDate(sign.getTimeStampToken().getTimeStampInfo().getGenTime().getTime());
                resp.setIsTimestampAvailable(sign.verifyTimestampImprint());
            } else {
                resp.setTimestampDate(null);
                resp.setIsTimestampAvailable(null);
            }
            list.add(resp);
        }
        return list;
    }

    public static void doVerifyAndReturnRevocationIfno(X509Certificate certificate, X509Certificate rootCa) throws Exception {
        try {
            certificate.checkValidity();
        }
        catch (CertificateExpiredException e) {
            System.out.println("[" + certificate.getSubjectDN().toString() + "]\u8bc1\u4e66\u8fc7\u671f");
        }
        if (rootCa != null) {
            certificate.verify(rootCa.getPublicKey());
        }
        PdfServiceImpl.verifyKeyUsage(certificate);
    }

    static RevocationInfo getRevocationInfo(X509Certificate certificate) throws Exception {
        try {
            X509CRL crl = PdfServiceImpl.getCrlObj(certificate);
            if (crl == null) {
                System.out.println("\u672a\u80fd\u89e3\u6790\u5230CRL\u5bf9\u8c61\u4fe1\u606f");
                return null;
            }
            X509CRLEntry x509CRLEntry = crl.getRevokedCertificate(certificate.getSerialNumber());
            if (x509CRLEntry == null) {
                return null;
            }
            RevocationInfo revocationInfo = new RevocationInfo();
            revocationInfo.setRevocationDate(x509CRLEntry.getRevocationDate());
            revocationInfo.setRevocationReson(x509CRLEntry.getRevocationReason().name());
            return revocationInfo;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new VerifyTerminateException("\u83b7\u53d6\u8bc1\u4e66\u540a\u9500\u4fe1\u606f\u5f02\u5e38:" + e.getMessage());
        }
    }

    private static X509CRL getCrlObj(X509Certificate certificate) throws Exception {
        byte[] extensionValue = certificate.getExtensionValue("2.5.29.31");
        if (extensionValue == null) {
            System.out.println("\u8bc1\u4e66\u6587\u4ef6\u4e0d\u5b58\u5728CRL\u5206\u53d1\u70b9\u4fe1\u606f");
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionValue);
        ASN1InputStream asn1InputStream = new ASN1InputStream((InputStream)byteArrayInputStream);
        DEROctetString derObject = (DEROctetString)asn1InputStream.readObject();
        DLSequence seq = (DLSequence)new ASN1InputStream(derObject.getOctets()).readObject();
        ArrayList<String> crlUrls = new ArrayList<String>();
        for (int i = 0; i < seq.size(); ++i) {
            ASN1Encodable tobj = seq.getObjectAt(i);
            while (!(tobj instanceof DEROctetString)) {
                if (tobj instanceof ASN1Sequence && ((ASN1Sequence)tobj).size() > 0) {
                    tobj = ((ASN1Sequence)tobj).getObjectAt(0);
                }
                if (!(tobj instanceof ASN1TaggedObject)) continue;
                tobj = ((ASN1TaggedObject)tobj).getObject();
            }
            String crlUrl = new String(((DEROctetString)tobj).getOctets());
            System.out.println(crlUrl);
            crlUrls.add(crlUrl);
        }
        X509CRL crl = null;
        for (String crlUrl : crlUrls) {
            if (crlUrl.startsWith("http")) {
                crl = PdfServiceImpl.getCrlByHttp(crlUrl);
            } else if (crlUrl.startsWith("ldap://")) {
                crl = PdfServiceImpl.getCrlByLdap(crlUrl);
            }
            if (crl == null) continue;
            break;
        }
        return crl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL getCrlByHttp(String crlUrl) throws Exception {
        X509CRL crl = null;
        try (ByteArrayInputStream in = null;){
            byte[] result = PdfServiceImpl.httpGet(crlUrl);
            in = new ByteArrayInputStream(result);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            crl = (X509CRL)cf.generateCRL(in);
        }
        return crl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509CRL getCrlByLdap(String crlUrl) throws Exception {
        if (crlUrl == null && "".equals(crlUrl)) {
            return null;
        }
        X509CRL crl = null;
        try (ByteArrayInputStream in = null;){
            crlUrl = crlUrl.replace("ldap://", "LDAP://");
            LdapContext ctx = PdfServiceImpl.ldapConnect(crlUrl);
            byte[] fileContent = null;
            if (ctx == null) {
                X509CRL x509CRL = null;
                return x509CRL;
            }
            String filter = "objectClass=cRLDistributionPoint";
            String[] attrPersonArray = new String[]{"certificateRevocationList;binary"};
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            searchControls.setReturningAttributes(attrPersonArray);
            NamingEnumeration<SearchResult> answer = ctx.search("", filter.toString(), searchControls);
            while (answer.hasMore() && fileContent == null) {
                SearchResult result = answer.next();
                NamingEnumeration<? extends Attribute> attrs = result.getAttributes().getAll();
                if (!attrs.hasMore()) continue;
                Attribute attr = attrs.next();
                fileContent = (byte[])attr.get();
            }
            in = new ByteArrayInputStream(fileContent);
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            crl = (X509CRL)cf.generateCRL(in);
        }
        return crl;
    }

    private static LdapContext ldapConnect(String url) {
        Hashtable<String, String> env = new Hashtable<String, String>();
        String factory = "com.sun.jndi.ldap.LdapCtxFactory";
        env.put("java.naming.factory.initial", factory);
        env.put("java.naming.security.authentication", "none");
        env.put("java.naming.provider.url", url);
        env.put("java.naming.security.principal", "");
        env.put("java.naming.security.credentials", "");
        env.put("java.naming.batchsize", "1000");
        env.put("com.sun.jndi.ldap.connect.timeout", "5000");
        InitialLdapContext ldapContext = null;
        try {
            ldapContext = new InitialLdapContext(env, null);
            System.out.println("ldap connect success");
        }
        catch (AuthenticationException e) {
            System.out.println("ldap\u8ba4\u8bc1\u5931\u8d25");
        }
        catch (NamingException e) {
            System.out.println("ldap\u53c2\u6570\u6709\u8bef\u5bfc\u81f4\u8fde\u63a5\u5931\u8d25");
        }
        return ldapContext;
    }

    private static byte[] httpGet(String url) throws Exception {
        MediaType mediaType = MediaType.parse((String)"application/json; charset=utf-8");
        OkHttpClient client = new OkHttpClient().newBuilder().connectTimeout(10L, TimeUnit.SECONDS).readTimeout(10L, TimeUnit.SECONDS).writeTimeout(10L, TimeUnit.SECONDS).sslSocketFactory(PdfServiceImpl.createSSLSocketFactory()).hostnameVerifier(new HostnameVerifier(){

            @Override
            public boolean verify(String hostname, SSLSession session) {
                return true;
            }
        }).build();
        HttpUrl.Builder urlBuilder = HttpUrl.parse((String)url).newBuilder();
        HttpUrl finalUrl = urlBuilder.build();
        Request request = new Request.Builder().get().url(finalUrl).build();
        Response response = null;
        response = client.newCall(request).execute();
        byte[] result = response.body().bytes();
        if (response.isSuccessful()) {
            return result;
        }
        throw new Exception("http\u8bf7\u6c42\u5931\u8d25,Url: " + url + "\u72b6\u6001\u7801: " + response.code() + ", \u8bf7\u6c42\u7ed3\u679c: " + result);
    }

    private static SSLSocketFactory createSSLSocketFactory() throws Exception {
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts, new SecureRandom());
        SSLSocketFactory sslSocketFactory = sslContext.getSocketFactory();
        return sslSocketFactory;
    }

    private static void verifyKeyUsage(X509Certificate certificate) throws VerifyTerminateException {
        boolean[] keyUsages = certificate.getKeyUsage();
        if (!keyUsages[0]) {
            throw new VerifyTerminateException("\u5bc6\u94a5\u7528\u6cd5\u9a8c\u8bc1\u65e0\u6548:digital_signature");
        }
        if (!keyUsages[1]) {
            throw new VerifyTerminateException("\u5bc6\u94a5\u7528\u6cd5\u9a8c\u8bc1\u65e0\u6548:non_repudiation");
        }
    }

    static {
        BouncyCastleProvider bcp = new BouncyCastleProvider();
        Security.insertProviderAt((Provider)bcp, 1);
        log.info("\u52a0\u8f7d\u7b97\u6cd5\u5e93");
        trustAllCerts = new TrustManager[]{new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
    }
}

