package com.xforceplus.tech.base;

import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.metadata.spec.Metadata;

import java.util.Collection;
import java.util.List;

/**
 * TODO multi context
 * registry for base component registry
 */
public interface BaseComponentRegistry {

    <T extends BaseComponent> T create(String name, Class<T> component, Metadata metadata);

    <T extends BaseComponent> T create(String uniqueName, String name, Class<T> component, Metadata metadata);

    void register(String token, BaseComponent baseComponent);

    void unRegister(String token);

    <T extends BaseComponent> List<T> findByKind(Class<T> cls);

    <T extends BaseComponent> List<T> findByKindAndScenes(Class<T> clas, List<Scene> scenes);

    <T extends BaseComponent> T findByKindAndName(String name, Class<T> cls);

    <T extends BaseComponent> T findByKindAndNameWithScenes(String name, Class<T> cls, List<Scene> scenes, Collection<DynamicSceneProvider> providers);

    <T extends BaseComponent> T findByKindAndNameWithScenes(String name, Class<T> cls, List<Scene> scenes);

}
