package com.xforceplus.tech.base.core.context;

import java.util.Collection;

/**
 * context keys
 */
public final class ContextKeys {

    public enum StringKeys implements ContextService.ContextKey<String> {
        /**
         * 租户代码
         */
        TENANTCODE_KEY,
        /**
         * 上下文请求头信息存储
         */
        XEP_CONTEXT_REQUEST_HEADER,
        /**
         * 上下文响应头信息存储
         */
        XEP_CONTEXT_RESPONSE_HEADER,

        USERNAME,

        USER_DISPLAYNAME,

        OPERATION_NAME,

        TRANSACTION_KEY,

        TENANTID_KEY,

        APPCODE,

        INVOKER_INFO,

        USER_LOGINNAME

    }

    public enum LongKeys implements ContextService.ContextKey<Long> {
        /**
         * 暂时不用这些
         */
        APP_ID,

        TENANT_ID,

        SYS_ORG_ID,

        ACCOUNT_ID,

        ID;
    }

    public enum CollectionKeys implements ContextService.ContextKey<Collection> {
        /**
         * 暂时不用这些
         */
        ROLE_CODES,


        ROLE_IDS
    }

}
