package com.xforceplus.tech.base.core.context;

import java.util.Map;

/**
 * request context
 */
public interface ContextService {

    interface ContextKey<T> {

        default Class<T> type(){
            return null;
        }

        String name();
    }

    /**
     * set attribute
     * @param key
     * @param value
     */
    <T> void set(ContextKey<T> key, T value);

    /**
     * get attribute
     * @param key
     * @param <T>
     * @return
     */
    <T> T get(ContextKey<T> key);

    Map<String, Object> getAll();

    void fromMap(Map<String, Object> maps);

    void clear();
}
