package com.xforceplus.tech.base.core.context.advice;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.MethodParameter;
import org.springframework.http.MediaType;
import org.springframework.http.server.ServerHttpRequest;
import org.springframework.http.server.ServerHttpResponse;
import org.springframework.util.Base64Utils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.servlet.mvc.method.annotation.ResponseBodyAdvice;

import java.nio.charset.StandardCharsets;

/**
 * xplat-tech-core
 *
 * @Author 👽 zhaolei
 * @Date 📅 2022/9/19 17:03
 * @Motto: Tools change the world. 🛠
 * @Copyright: xforceplus 🇨🇳
 * @Description:
 */
@ControllerAdvice
public class ContextServiceResponseAdvice implements ResponseBodyAdvice {
    private final Logger log = LoggerFactory.getLogger(this.getClass());

    private final ContextService contextService;

    public ContextServiceResponseAdvice(ContextService contextService) {
        this.contextService = contextService;
    }

    @Override
    public boolean supports(MethodParameter returnType, Class converterType) {
        return true;
    }

    @Override
    public Object beforeBodyWrite(Object body, MethodParameter returnType, MediaType selectedContentType, Class selectedConverterType, ServerHttpRequest request, ServerHttpResponse response) {
        String xepContext = contextService.get(ContextKeys.StringKeys.XEP_CONTEXT_RESPONSE_HEADER);

        if (!StringUtils.isEmpty(xepContext)) {
            response.getHeaders().set("Xep-Context", Base64Utils.encodeToString(xepContext.getBytes(StandardCharsets.UTF_8)));
        }
        return body;
    }
}
