package com.xforceplus.tech.base.core.context.impl;

import com.xforceplus.tech.base.core.context.ContextService;

import java.util.Map;

/**
 *  default context service depends on ThreadLocal
 */
public class DefaultContextServiceImpl implements ContextService {

    final
    private ThreadLocalContextHolder threadlocalContextHolder;

    public DefaultContextServiceImpl(ThreadLocalContextHolder threadlocalContextHolder) {
        this.threadlocalContextHolder = threadlocalContextHolder;
    }

    @Override
    public <T> void set(ContextKey<T> key, T value) {
        threadlocalContextHolder.context().put(key.name(), value);
    }

    @SuppressWarnings("unchecked")
    @Override
    public <T> T get(ContextKey<T> key) {
        try {
            return (T) threadlocalContextHolder.context().get(key.name());
        }catch(RuntimeException ex){
            //in normal way here is dead code
            throw new RuntimeException("Error to cast object to expected Class");
        }
    }

    @Override
    public Map<String, Object> getAll() {
        return threadlocalContextHolder.context();
    }

    @Override
    public void fromMap(Map<String, Object> maps) {
        threadlocalContextHolder.putContext(maps);
    }

    @Override
    public void clear() {
        threadlocalContextHolder.clearContext();
    }
}
