package com.xforceplus.tech.base.core.context.impl;

import java.util.Map;
import java.util.TreeMap;

public class ThreadLocalContextHolder {

    private ThreadLocal<Map<String , Object>> contextThreadLocal = new ThreadLocal<>();

    public Map<String, Object> context(){
        Map<String, Object> context = contextThreadLocal.get();
        if(context == null){
            context = new TreeMap<>();
            contextThreadLocal.set(context);
        }

        return context;
    }

    public void putContext(Map<String, Object> context){
        contextThreadLocal.set(context);
    }

    public void clearContext(){
        contextThreadLocal.remove();
    }

}
