package com.xforceplus.tech.base.core.context.interceptor;

import com.xforceplus.tech.base.core.context.ContextKeys;
import com.xforceplus.tech.base.core.context.ContextService;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ui.ModelMap;
import org.springframework.util.Base64Utils;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

import java.nio.charset.StandardCharsets;

public class ContextServiceInterceptor implements WebRequestInterceptor {
    private static final Logger log = LoggerFactory.getLogger(ContextServiceInterceptor.class);

    private final ContextService contextService;

    public ContextServiceInterceptor(ContextService contextService) {
        this.contextService = contextService;
    }

    @Override
    public void preHandle(WebRequest request) throws Exception {
        contextService.clear();
        String xepContext = request.getHeader("Xep-Context");
        if (StringUtils.isEmpty(xepContext)) {
            return;
        }
        try {
            log.debug("解析头信息xep-context-header");
            String decode = new String(Base64Utils.decode(xepContext.getBytes(StandardCharsets.UTF_8)), StandardCharsets.UTF_8);
            contextService.set(ContextKeys.StringKeys.XEP_CONTEXT_REQUEST_HEADER, decode);
        } catch (Exception e) {
            log.error("解析头信息xep-context-header异常：" + e.getMessage());
        }
    }

    @Override
    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    @Override
    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
        contextService.clear();
    }
}
