package com.xforceplus.tech.base.core.context.route;

import java.io.IOException;
import java.util.List;
import java.util.Map;

/**
 * request context
 */
public interface RouteConfigContext {


    void setEpList(List<String> epList);

    List<String> getEpList();

    void initRouteConfig(Map<String, List<RouteInfo>> value) throws IOException;

    boolean initRouteConfigByCacheFile() throws IOException;

    void saveCacheConfigByFile() throws IOException;

    void updateRouteConfig(Map<String, List<RouteInfo>> value) throws IOException;

    void setConfig(String key, List<RouteInfo> value);

    List<RouteInfo> getConfig(String key);

    Map<String, List<RouteInfo>> getAllConfig();

    void clearConfig();

    RouteInfo getMatchConfig(String tenantCode, String epCode, Object[] args);

}
