package com.xforceplus.tech.base.core.dispatcher;

import com.xforceplus.tech.base.core.dispatcher.interceptor.MessageDispatcherInterceptor;
import com.xforceplus.tech.base.core.dispatcher.messaging.QueryMessage;
import org.springframework.core.ResolvableType;

public interface ServiceDispatcher {

    void addQueryHandlerAdapter(QueryHandlerAdapter handlerAdapter);

    void addCommandHandlerAdapter(CommandHandlerAdapter handlerAdapter);

    void registerInterceptor(MessageDispatcherInterceptor<? super QueryMessage<?, ?>> handlerInterceptor);

    <R> R querySync(Object command, Class cls, String queryName);

    <R> R querySync(Object command, ResolvableType responseType);

    <R> R querySync(Object command, Class<R> responseType);
}
