package com.xforceplus.tech.base.core.dispatcher.interceptor;

import com.xforceplus.tech.base.core.dispatcher.messaging.Message;
import org.springframework.core.Ordered;
import org.springframework.core.ResolvableType;

import java.util.Collections;
import java.util.List;
import java.util.function.BiFunction;

public interface MessageDispatcherInterceptor<T extends Message<?>> extends Comparable<MessageDispatcherInterceptor>{

    default T handle(T message) {
        return handle(Collections.singletonList(message)).apply(0, message);
    }

    BiFunction<Integer, T, T> handle(List<? extends T> messages);

    default boolean isSupport(ResolvableType resolvableType){
        return true;
    }

    default int getOrder(){
        return Ordered.LOWEST_PRECEDENCE;
    }

    default int compareTo(MessageDispatcherInterceptor messageDispatcherInterceptor) {
        return Integer.compare(this.getOrder(), messageDispatcherInterceptor.getOrder());
    }
}
