package com.xforceplus.tech.base.core.dispatcher.messaging;

import java.util.Map;

public class GenericMessage<T> implements Message<T> {
    private static final long serialVersionUID = 7937214711724527316L;

    private final Class<T> payloadType;
    private final T payload;
    private final MetaData metaData;

    public GenericMessage(T payload, Class<T> payloadType, Map<String, ?> metaData) {
        this.payloadType = payloadType;
        this.payload = payload;
        this.metaData = MetaData.from(metaData);
    }

    @Override
    public String getIdentifier() {
        return null;
    }

    @Override
    public MetaData getMetaData() {
        return this.metaData;
    }

    @Override
    public T getPayload() {
        return payload;
    }

    @Override
    public Class<T> getPayloadType() {
        return payloadType;
    }

    @Override
    public Message<T> withMetaData(Map<String, ?> metaData) {
        if (metaData.isEmpty()) {
            return this;
        }
        return withMetaData(getMetaData().mergedWith(metaData));
    }

    @Override
    public Message<T> andMetaData(Map<String, ?> metaData) {
        if (getMetaData().equals(metaData)) {
            return this;
        }
        return withMetaData(MetaData.from(metaData));
    }

    protected Message<T> withMetaData(MetaData metaData) {
        return new GenericMessage<>(payload, payloadType, metaData);
    }
}