package com.xforceplus.tech.base.core.dispatcher.messaging;

import java.io.Serializable;
import java.util.Map;

public interface Message<T> extends Serializable {

    String getIdentifier();

    MetaData getMetaData();

    T getPayload();

    Class<T> getPayloadType();

    Message<T> withMetaData(Map<String, ?> metaData);

    Message<T> andMetaData(Map<String, ?> metaData);
}
