package com.xforceplus.tech.base.core.dispatcher.messaging.impl;

import com.xforceplus.tech.base.core.dispatcher.CommandHandlerAdapter;
import com.xforceplus.tech.base.core.dispatcher.QueryHandlerAdapter;
import com.xforceplus.tech.base.core.dispatcher.ServiceDispatcher;
import com.xforceplus.tech.base.core.dispatcher.interceptor.MessageDispatcherInterceptor;
import com.xforceplus.tech.base.core.dispatcher.messaging.GeneralResponse;
import com.xforceplus.tech.base.core.dispatcher.messaging.GenericQueryMessage;
import com.xforceplus.tech.base.core.dispatcher.messaging.Message;
import com.xforceplus.tech.base.core.dispatcher.messaging.QueryMessage;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.ResolvableType;

import java.lang.reflect.Method;
import java.util.*;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;

/**
 * service dispatcher
 */
public class ServiceDispatcherLocal implements ServiceDispatcher {

    private Logger logger = LoggerFactory.getLogger(ServiceDispatcher.class);

    private List<QueryHandlerAdapter> querys = new CopyOnWriteArrayList<>();

    private final List<MessageDispatcherInterceptor<? super QueryMessage<?, ?>>> handlerInterceptors
            = new CopyOnWriteArrayList<>();

    private List<QueryHandlerAdapter> retrieveAdapter(ResolvableType input, ResolvableType output) {
        return querys.stream()
                .filter(x -> x.supportsQueryType(input, output))
                .collect(Collectors.toList());
    }

    @SuppressWarnings("unchecked")
    private <Q, R, T extends QueryMessage<Q, R>> T processInterceptors(T query) {
        T intercepted = query;

        List<MessageDispatcherInterceptor<? super QueryMessage<?, ?>>> ordered =
                handlerInterceptors.stream().sorted().collect(Collectors.toList());

        for (MessageDispatcherInterceptor<? super QueryMessage<?, ?>> interceptor : ordered) {
            if (interceptor.isSupport(ResolvableType.forClass(query.getPayload().getClass()))) {
                intercepted = (T) interceptor.handle(intercepted);
            }
        }
        return intercepted;
    }

    //TODO
    private Optional<GeneralResponse> invokeInner(List<QueryHandlerAdapter> queryHandlerAdapters, Object command) {
        return queryHandlerAdapters.stream()
                .sorted(Comparator.comparingInt(QueryHandlerAdapter::getOrder))
                .map(x ->
                {
                    try {
                        return x.processMsg(processInterceptors(new GenericQueryMessage(command, ResolvableType.forClass(command.getClass()), new HashMap<>())));
                    } catch (Throwable ex) {
                        logger.error("{}", ex);
                        return GeneralResponse.error(ex);
                    }
                }).filter(Objects::nonNull)
                .findFirst();
    }

    @Override
    public void addQueryHandlerAdapter(QueryHandlerAdapter handlerAdapter) {
        querys.add(handlerAdapter);
    }

    @Override
    public void addCommandHandlerAdapter(CommandHandlerAdapter handlerAdapter) {
        //TODO
    }

    @Override
    public void registerInterceptor(MessageDispatcherInterceptor<? super QueryMessage<?, ?>> handlerInterceptor) {
        handlerInterceptors.add(handlerInterceptor);
    }

    @Override
    public <R> R querySync(Object command, Class cls, String queryName) {
        Optional<ResolvableType> typeOp = Stream.of(cls.getMethods())
                .filter(method -> isMatch(method, queryName, command.getClass()))
                .findFirst()
                .map(ResolvableType::forMethodReturnType);
        return typeOp.<R>map(resolvableType -> querySync(command, resolvableType))
                .orElse(null);
    }


    private boolean isMatch(Method method, String queryName, Class cmdCls) {

        ResolvableType resolvableType = ResolvableType.forMethodParameter(method, 0);

        return queryName.equalsIgnoreCase(method.getName())
                &&
                method.getParameterCount() == 1
                &&
                (resolvableType.isAssignableFrom(ResolvableType.forClass(cmdCls))
                        ||
                        //allow Message wrapper
                        (ResolvableType.forClass(Message.class)
                                .isAssignableFrom(resolvableType)
                                && isInGenerics(resolvableType, cmdCls)));
    }

    private boolean isInGenerics(ResolvableType resolvableType, Class cmdCls) {
        ResolvableType[] generics = resolvableType.getGenerics();
        if (generics.length > 0) {
            //no more generics here
            return generics[0].isAssignableFrom(cmdCls);
        }
        return false;
    }

    @Override
    public <R> R querySync(Object command, Class<R> responseType) {
        return querySync(command, ResolvableType.forClass(responseType));
    }

    @Override
    public <R> R querySync(Object command, ResolvableType responseType) {

        List<QueryHandlerAdapter> adapters = retrieveAdapter(ResolvableType.forClass(command.getClass())
                , responseType);

        Map<Boolean, List<QueryHandlerAdapter>> listMap =
                adapters.stream().collect(Collectors.groupingBy(QueryHandlerAdapter::isDefault));

        /**
         * invoke
         */
        Optional<GeneralResponse> grOp = invokeInner(Optional.ofNullable(listMap.get(false))
                .orElseGet(Collections::emptyList), command);

        if (!grOp.isPresent()) {
            grOp = invokeInner(Optional.ofNullable(listMap.get(true))
                    .orElseGet(Collections::emptyList), command);
        }


        if(grOp.isPresent()){
            GeneralResponse generalResponse = grOp.get();

            if(generalResponse.getThrowable() != null){
                throw new RuntimeException(generalResponse.getThrowable());
            } else {
                return (R)generalResponse.getT();
            }

        }

        return null;
    }

    //fire
    public <R> CompletableFuture<R> send(Object command) {
        return null;
    }

    //req-request query side
    public <R, Q> CompletableFuture<R> query(Q request, Class<R> responseType) {
        return null;
    }
}
