package com.xforceplus.tech.base.core.dispatcher.process.config;

import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.business.configpoint.ConfigPoint;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * config repository
 */
public class ConfigRepository implements ApplicationContextAware {

    private BaseComponentRegistry registry;


    private ApplicationContext context;

    @Autowired
    private ContextService contextService;

    public ConfigRepository(BaseComponentRegistry registry) {
        this.registry = registry;
    }

    public Optional<ConfigPoint> configPoint(String configName) {

        Map<String, DynamicSceneProvider> beansOfType = context.getBeansOfType(DynamicSceneProvider.class);
        List<Scene> scenes = beansOfType.values().stream().flatMap(x -> x.getSceneViaContext(contextService.getAll())
                .stream()).collect(Collectors.toList());

        ConfigPoint configPoint = registry.findByKindAndNameWithScenes(configName, ConfigPoint.class, scenes, beansOfType.values());
        if(configPoint == null || !configPoint.enabled()) {
            return Optional.empty();
        } else {
            return Optional.of(configPoint);
        }
    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.context = applicationContext;
    }
}
