package com.xforceplus.tech.base.core.dispatcher.process.impl;

import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.core.dispatcher.process.CustomActionComponent;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.business.processflow.dsl.ProcessContext;
import com.xforceplus.tech.business.processflow.dsl.ProcessStage;
import com.xforceplus.tech.business.processflow.dsl.pred.CustomActionStage;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class CustomActionProcessStageExecutor extends ProcessStageExecutorSupport {

    public CustomActionProcessStageExecutor(BaseComponentRegistry registry) {
        super(registry);
    }

    @Override
    public boolean required(ProcessStage processStage) {
        return processStage instanceof CustomActionStage;
    }

    @Override
    public Object doProcess(ProcessStage processStage, ProcessContext processContext) {
        Class aClass = processStage.wrapperClass();

        Object lastOutput = processContext.getLastOutput();
        List<Scene> currentScenes = processContext.getCurrentScenes();

        List<CustomActionComponent> customActionComponents = getRegistry()
                .findByKindAndScenes(CustomActionComponent.class, currentScenes);

        Optional<CustomActionComponent> firstComponent = customActionComponents
                .stream().filter(x -> x.getRawClass() == aClass).findFirst();

        if(firstComponent.isPresent()) {
            CustomActionComponent customActionComponent = firstComponent.get();
            Object[] args = getArgsFromContext(processContext, customActionComponent.params());
            Object o = customActionComponent.doInvoke(args);
            return o;
        } else {
            throw new RuntimeException("No Action found");
        }

    }

    Object[] getArgsFromContext(ProcessContext processContext, Class[] params) {
        List<Object> objects = new ArrayList<>();
        objects.add(processContext.getLastOutput());
        objects.addAll(processContext.getContextMap().values());

        Object[] args = Arrays.stream(params).map(param -> {
            Optional<Object> p = objects.stream().filter(obj -> param.isAssignableFrom(obj.getClass())).findFirst();
            return p.orElse(null);
        }).toArray(Object[]::new);

        return args;
    }
}
