package com.xforceplus.tech.base.core.dispatcher.process.impl;

import com.xforceplus.tech.base.BaseComponent;
import com.xforceplus.tech.base.BaseComponentRegistry;
import com.xforceplus.tech.base.core.context.ContextService;
import com.xforceplus.tech.base.core.dispatcher.process.ProcessStageExecutor;
import com.xforceplus.tech.base.core.dispatcher.process.ServiceProcessDispatcher;
import com.xforceplus.tech.base.scene.DynamicSceneProvider;
import com.xforceplus.tech.base.scene.Scene;
import com.xforceplus.tech.business.converter.Converter;
import com.xforceplus.tech.business.processflow.ProcessFlow;
import com.xforceplus.tech.business.processflow.dsl.ProcessContext;
import com.xforceplus.tech.business.processflow.dsl.ProcessDAG;
import com.xforceplus.tech.business.processflow.dsl.ProcessDSL;
import com.xforceplus.tech.business.processflow.dsl.ProcessStage;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

/**
 * default dispatcher
 */
public class DefaultServiceProcessDispatcher implements ServiceProcessDispatcher, ApplicationContextAware {

    private BaseComponentRegistry registry;

    private ApplicationContext applicationContext;

    private ContextService contextService;

    private List<ProcessStageExecutor> executors;

    public DefaultServiceProcessDispatcher(BaseComponentRegistry registry
            , ContextService contextService, List<ProcessStageExecutor> executors) {
        this.registry = registry;
        this.contextService = contextService;
        this.executors = executors;
    }

    @Override
    public <T, R, F> R invoke(String name, T mainRequest, Class<R> retClass) {
        Map<String, DynamicSceneProvider> beansOfType = applicationContext.getBeansOfType(DynamicSceneProvider.class);
        List<Scene> scenes = beansOfType.values().stream().flatMap(x -> x.getSceneViaContext(contextService.getAll())
                .stream()).collect(Collectors.toList());
        ProcessFlow processFlow = registry.findByKindAndNameWithScenes(name, ProcessFlow.class, scenes);

        if (processFlow == null) {
            throw new RuntimeException("Cannot find Process with name:" + name);
        }

        /**
         * get define
         */
        ProcessDSL define = processFlow.define();

        /**
         * current only can do the flow
         * no fan-out and join
         */
        ProcessContext processContext = new ProcessContext(mainRequest, contextService.getAll());
        ProcessDAG processDAG = define.getProcessDAG();
        while (processDAG.hasNext()) {
            ProcessStage next = processDAG.next();
            processContext = doExecutionProcessStage(next, processContext);
        }

        Object lastOutput = processContext.getLastOutput();
        if (lastOutput != null) {
            if (retClass.isAssignableFrom(lastOutput.getClass())) {
                return (R) lastOutput;
            } else {
                Optional<Converter> implicityConverter = findImplicityConverter(lastOutput, retClass, scenes);
                if (implicityConverter.isPresent() && implicityConverter.get().isImplicitly()) {
                    Converter converter = implicityConverter.get();
                    Object convert = converter.convert(lastOutput);
                    if(convert == null) {
                        return null;
                    } else if (retClass.isAssignableFrom(convert.getClass())) {
                        return (R) convert;
                    } else {
                        throw new RuntimeException("Fatal error output is not the target class");
                    }
                } else {
                    throw new RuntimeException("No convert found");
                }
            }
        }

        return null;
    }

    /**
     * current not support chain
     *
     * @param object
     * @param targetClass
     * @param scenes
     * @return
     */
    private Optional<Converter> findImplicityConverter(Object object, Class targetClass, List<Scene> scenes) {
        List<Converter> converters = registry.findByKindAndScenes(Converter.class, scenes);
        Optional<Converter> converterOp = converters.stream().filter(c -> c.support(object.getClass(), targetClass)).findFirst();
        return converterOp;
    }

    /**
     * TODO how to do the execution
     * TODO event
     *
     * @param stage
     * @param processContext
     * @return
     */
    private ProcessContext doExecutionProcessStage(ProcessStage stage, ProcessContext processContext) {
        Optional<ProcessStageExecutor> executorOp = executors.stream().filter(x -> x.required(stage)).findFirst();
        if (executorOp.isPresent()) {
            ProcessStageExecutor processStageExecutor = executorOp.get();
            Object output = processStageExecutor.doProcess(stage, processContext);
            return processContext.withLastOutput(output);
        } else {
            throw new RuntimeException("Executor not found for" + stage.wrapperClass());
        }
    }

//    @Override
//    public <T, R> Tuple2<R, ProcessContext> invoke(String name, T mainRequest, Map<String, Object> context, Class<R> retClass) {
//        return null;
//    }

    @Override
    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }
}
